-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Strings.Unbounded, Io_Types;
package Io_Icd_File is

   type Instance is private;

   procedure Open
     ( A_Filename  : in String;
       An_Instance : out Instance );

   procedure Close
     ( An_Instance : in Instance );

   type Natural_Direction_Array is
     array ( Io_Types.Direction ) of Natural;

   procedure Read_Header
     ( An_Instance : in Instance;
       The_Number_Of_Entries : out Natural;
       The_Sizes : out Natural_Direction_Array;
       The_Offsets : out Natural_Direction_Array;
       The_Memory_Size : out Natural;
	   The_Version : out Natural );

       -- Offsets in the ICD file are given in bytes from the beginning
      -- of a hypothetical buffer which includes a control section, an
      -- input section, and an output section.  (This is a legacy of
      -- the bidirectional reflective memory interface -- Bit3
      -- formerly used by FSI to interface the host and subsystem
      -- computers.) The offset and size of each section is given in
      -- the header of the ICD file and returned by procedure
      -- Read_Header.  The input or output section offset must be used
      -- to calculate the offset of each entry with respect to the
      -- input or output buffer.

   procedure Read_Entry
     ( An_Instance : in Instance;
       The_Mnemonic : out Ada.Strings.Unbounded.Unbounded_String;
       The_Direction : out Io_Types.Direction;
       The_Size : out Natural;
       The_Offset : out Natural;
       At_End_Of_File : out Boolean );

   Cannot_Open : exception;

   Bad_Header : exception;

   Bad_Format : exception;

   Control_Entry : exception;
   -- This is raised by Read_Entry when the entry read is neither
   -- input nor output, but an entry in the unused control section.
   -- The calling application should trap the exception and ignore the
   -- entry.

private

   type Stdio_File;

   type Stdio_File_Ptr is access constant Stdio_File;

   type Instance is
     record
        File_Ptr : Stdio_File_Ptr;
        Filename : Ada.Strings.Unbounded.Unbounded_String;
		Version  : Natural ;
     end record;

end Io_Icd_File;
