-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with System;
with Ada.Streams;
package Io_Buffer is

   -- Class of amorphous I/O buffer, used to transmit and receive data
   -- between host simulation software and simulation subsystems

   type Handle is private;

   function Create
     ( A_Size : in Positive )
      return Handle;
   -- Create a new I/O buffer of the specified size in bytes

   function Size
     ( A_Handle : in Handle )
      return Natural;
   -- Return the size in bytes

   function Address
     ( A_Handle : in Handle )
     return System.Address;
   -- return the address of the start of the buffer

   function Address_Of_Offset
     ( A_Handle : in Handle;
       An_Offset : in Natural )
     return System.Address;
   -- Return the address of an offset in bytes from the beginning of the buffer

   procedure Clear
     ( A_Handle : in Handle );
   -- Zero the buffer.

   procedure Save
     (A_Handle : in Handle;
      To_Stream : access Ada.Streams.Root_Stream_Type'Class);

   procedure Restore
     (A_Handle : in Handle;
      From_Stream : access Ada.Streams.Root_Stream_Type'Class);

   function Snapshot_Size
     (A_Handle : in Handle)
     return Natural;
   -- actual number of bytes output when a snapshot is written to a stream

   Snapshot_Size_Mismatch : exception;

private

   type Instance;

   type Handle is access all Instance;

end Io_Buffer;


