-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

generic
   type Item is private;
package Dictionary is

   -- An abstract collection of records indexed by name

   type Handle is private;

   type Item_Handle is access all Item;

   function Create
     return Handle;
   -- Create new dictionary

   procedure Add_Item
     ( A_Dictionary : in Handle;
       An_Item : in Item );
   -- Add new item to existing dictionary

   procedure Delete_Item
     ( A_Dictionary : in Handle;
       An_Item : in Item );
   -- Delete item from dictionary

   function Find_Item
     ( A_Dictionary : in Handle;
       A_Name : in String )
     return Item_Handle;
   -- Find_Item returns Item for name; returns null if an Item containing
   -- the name is not in the dictionary

   -- First_Item and Next_Item facilitate iterating through a dictionary

   function First_Item
     ( A_Dictionary : in Handle )
     return Item_Handle;
   -- Return first item in the dictionary; return null if dictionary is
   -- empty

   function Next_Item
     ( A_Dictionary : in Handle;
       An_Item_Handle : in Item_Handle )
     return Item_Handle;
   -- Return item in the dictionary which follows the one passed in; return
   -- null if item passed in is the last item


private

   -- Implementation is defined in the package body.
   -- (Currently TBD, likely will be defined using balanced binary trees,
   -- once they are released as part of the Ada95 Booch Components.)

   type Instance;

   type Handle is access all Instance;

end Dictionary;