-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package body Dictionary is

   -- An abstract collection of records indexed by name

   type Instance is
      null record;

   function Create
     return Handle is
      -- Create new dictionary
      New_Handle : Handle := new Instance;
   begin
      return New_Handle;
   end Create;

   procedure Add_Item
     ( A_Dictionary : in Handle;
       An_Item : in Item ) is
   -- Add new item to existing dictionary
   begin
      null;
   end Add_Item;

   procedure Delete_Item
     ( A_Dictionary : in Handle;
       An_Item : in Item ) is
   -- Delete item from dictionary
   begin
      null;
   end Delete_Item;

   function Find_Item
     ( A_Dictionary : in Handle;
       A_Name : in String )
     return Item_Handle is
   -- Find_Item returns Item for name; returns null if an Item containing
   -- the name is not in the dictionary
   begin
      return null;
   end Find_Item;


   -- First_Item and Next_Item facilitate iterating through a dictionary

   function First_Item
     ( A_Dictionary : in Handle )
     return Item_Handle is
   -- Return first item in the dictionary; return null if dictionary is
   -- empty
   begin
      return null;
   end First_Item;

   function Next_Item
     ( A_Dictionary : in Handle;
       An_Item_Handle : in Item_Handle )
     return Item_Handle is
   -- Return item in the dictionary which follows the one passed in; return
   -- null if item passed in is the last item
   begin
      return null;
   end Next_Item;

end Dictionary;