-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package provides utilities to the ARINC 429 packages.
-------------------------------------------------------------------------------

with Ada.Unchecked_Conversion;
with Arinc_429_Types;
with Interfaces.C;
package Arinc_429_Utils is

   -- Calculate a bitwise-reversed octal label.

   function To_Reversed_Label ( A_Label : in Arinc_429_Types.Octal_Label )
     return Arinc_429_Types.Reversed_Octal_Label;

   -- Calculate the value of the parity bit required to give an ARINC 429 message
   -- odd parity (an odd number of one bits).

   function Odd_Parity_Bit ( A_Message : in Arinc_429_Types.Message_Type )
                            return Boolean;

   -- conversion between standard message structure, with a 2-bit SDI field
   -- and a message where the SDI field is used for the data

   function To_No_Sdi_Message is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.Message_Type,
       Arinc_429_Types.No_Sdi_Message_Type );

   function To_Message is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.No_Sdi_Message_Type,
       Arinc_429_Types.Message_Type );

   -- conversions between message types and 32-bit-long array
   -- representation of a message

   function To_Unsigned_Bit_Array is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.Message_Type,
       Arinc_429_Types.Unsigned_Bit_Array );

   function To_Message is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.Unsigned_Bit_Array,
       Arinc_429_Types.Message_Type );

   function To_Unsigned_Bit_Array is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.No_Sdi_Message_Type,
       Arinc_429_Types.Unsigned_Bit_Array );

   function To_No_Sdi_Message is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.Unsigned_Bit_Array,
       Arinc_429_Types.No_Sdi_Message_Type );

   -- conversion between 32-bit-wide bit-arrays and 32 bit signed and unsigned ints

   function To_Unsigned_Bit_Array is new Ada.Unchecked_Conversion
     ( Interfaces.C.Int,
       Arinc_429_Types.Unsigned_Bit_Array );

   function To_Unsigned_Bit_Array is new Ada.Unchecked_Conversion
     ( Interfaces.C.Unsigned,
       Arinc_429_Types.Unsigned_Bit_Array );

   function To_Int is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.Unsigned_Bit_Array,
       Interfaces.C.Int );

   function To_Unsigned is new Ada.Unchecked_Conversion
     ( Arinc_429_Types.Unsigned_Bit_Array,
       Interfaces.C.Unsigned );

end Arinc_429_Utils;
