-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package defines the structure of a generic ARINC 429 32-bit
-- message as a series of unsigned integers of specified sizes.
-------------------------------------------------------------------------------

with Interfaces.C;
package Arinc_429_Types is

   -- lengths of the fields

   Label_Field_Length : constant := 8;
   Value_Field_Length : constant := 19;
   Sdi_Field_Length : constant := 2;
   Ssm_Field_Length : constant := 2;
   No_Sdi_Value_Field_Length : constant := Value_Field_Length + Sdi_Field_Length;

   -- unsigned integer types defined in terms of the specified lengths

   type Octal_Label is mod 2 ** Label_Field_Length;

   type Reversed_Octal_Label is mod 2 ** Label_Field_Length;

   type Bit_Array is
      array ( Positive range <> ) of Boolean;
   pragma Pack ( Bit_Array );

   subtype Unsigned_Bit_Array is
     Arinc_429_Types.Bit_Array ( 1 .. Interfaces.C.Unsigned'Size );

   subtype Value_Field_Type is Bit_Array ( 1 .. Value_Field_Length );
--   pragma Pack ( Value_Field_Type );
   -- max 19 bits for data

   subtype No_Sdi_Value_Field_Type is Bit_Array  ( 1 .. No_Sdi_Value_Field_Length );
--   pragma Pack ( No_Sdi_Value_Field_Type );
   -- max 21 bits for data

   Zero_Unsigned_Bit_Array : constant Unsigned_Bit_Array := ( others => False );

   Ones_Unsigned_Bit_Array : constant Unsigned_Bit_Array := ( others => True );

   Zero_Value_Field : constant Value_Field_Type := ( others => False );

   Zero_No_Sdi_Value_Field : constant No_Sdi_Value_Field_Type := ( others => False );

   type Sdi_Field_Type is mod 2 ** Sdi_Field_Length;

   type Ssm_Field_Type is mod 2 ** Ssm_Field_Length;


   -- message structure defined beginning with least significant bit

   type Message_Type is
      record
         The_Label : Reversed_Octal_Label;     -- Bits  1 -  8
         The_Sdi : Sdi_Field_Type;             -- Bits  9 - 10
         The_Value : Value_Field_Type;         -- Bits 11 - 29
         The_Ssm : Ssm_Field_Type;             -- Bits 30 - 31
         The_Parity_Bit : Boolean;             -- Bit  32
      end record;

   for Message_Type use
      record
         The_Label      at 0 range 0 .. 7;
         The_Sdi        at 0 range 8 .. 9;
         The_Value      at 0 range 10 .. 28;
         The_Ssm        at 0 range 29 .. 30;
         The_Parity_Bit at 0 range 31 .. 31;
      end record;

   type No_Sdi_Message_Type is
      record
         The_Label : Reversed_Octal_Label;     -- Bits  1 -  8
         The_Value : No_Sdi_Value_Field_Type;  -- Bits  9 - 29
         The_Ssm : Ssm_Field_Type;             -- Bits 30 - 31
         The_Parity_Bit : Boolean;             -- Bit  32
      end record;

   for No_Sdi_Message_Type use
      record
         The_Label      at 0 range 0 .. 7;
         The_Value      at 0 range 8 .. 28;
         The_Ssm        at 0 range 29 .. 30;
         The_Parity_Bit at 0 range 31 .. 31;
      end record;

   -- Pack will squeeze each field down to its 'Size

   pragma Pack (Message_Type);
   pragma Pack (No_Sdi_Message_Type);

   -- Frequently-used values for Source/Destination Identifier and Sign/Status Matrix

   type Sdi_Type is
     ( All_Call, First, Second, Third );

   type Discrete_Ssm_Type is
      (Normal, No_Computed_Data,Functional_Test,Failure);

   type Bnr_Ssm_Type is
     ( Failure, No_Computed_Data, Functional_Test, Normal );

   type Bcd_Ssm_Type is
     ( Positive, No_Computed_Data, Functional_Test, Negative );

   type Bcd_North_South_Ssm_Type is
     ( North, No_Computed_Data, Functional_Test, South );

   type Bcd_East_West_Ssm_Type is
     ( East, No_Computed_Data, Functional_Test, West );

   type Bcd_Right_Left_Ssm_Type is
     ( Right, No_Computed_Data, Functional_Test, Left );

   type Bcd_To_From_Ssm_Type is
     ( To, No_Computed_Data, Functional_Test, From );

   type Bcd_To_Above_Below_Type is
     ( Above, No_Computed_Data, Functional_Test, Below );

   -- Use No_Discretes_Type to instantiate generics when no discretes
   -- are needed in a BNR or BCD message

   type No_Discretes_Type is null record;

   -- Use Accuracy_Discretes_Type to instantiate generics when bit 11
   -- is to be used to indicate degraded accuracy

   type Accuracy_Discretes_Type is
      record
         Degraded : Boolean;
      end record;
   pragma Pack ( Accuracy_Discretes_Type );

end Arinc_429_Types;
