-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- An instantiation of this package provides procedures for packing
-- discrete data into an ARINC 429 32-bit message.
--
-- The first generic formal parameter is the label, which should be
-- supplied as an eight-bit octal number, in the range 8#000# to
-- 8#377#.  The package handles the required reversal of the label.
--
-- Discretes_Type: any type, but Discretes_Type'Size must be less than
--      the number of bits in the value field.  The Pack procedure stores
--      a value of Discretes_Type in the ARINC 429 message beginning at bit 11
--      (where the LSB of an ARINC 429 message is defined as bit 1), or
--      at bit 9 if SDI_Bits_Used is True.
--
-- Sdi_Type: an enumeration type of no more than 4 values, defining the
--      meaning of the two bits of the Source/Destination Identifier.
--
-- Ssm_Type: an enumeration type of no more than 4 values, defining the
--      meaning of the two bits of the Sign/Status Matrix.
--
-- No_SDI : a Boolean which indicates whether the SDI bits are used
--      as the SDI (No_SDI = FALSE), or as part of the Discretes_Type
--      (No_SDI = TRUE).
--
-------------------------------------------------------------------------------
with Arinc_429_Types;
with System; -- TEMP
generic
   Label : Arinc_429_Types.Octal_Label;
   type Discretes_Type is private;
   type Sdi_Type is (<>);
   type Ssm_Type is (<>);
   No_Sdi : Boolean;
package Arinc_429_Discrete is

   function Pack ( A_Discretes_Value : in Discretes_Type;
                   A_Sdi : in Sdi_Type;
                   A_Ssm : in Ssm_Type )
     return Arinc_429_Types.Message_Type;

   procedure Unpack ( A_Message : in Arinc_429_Types.Message_Type;
                      A_Discretes_Value : out Discretes_Type;
                      A_Sdi : out Sdi_Type;
                      A_Ssm : out Ssm_Type );

   -- Exceptions are raised during elaboration of the instantiated package, to
   -- indicate that invalid types were used to instantiate the package.  Wish
   -- we could check this at compile time, but that doesn't seem to be possible.

   Discretes_Type_Size_Mismatch : exception;
   -- Discretes_Type'Size /= Discretes_Mod_Type'Size

   Discretes_Type_Too_Big : exception;
   -- Discretes_Type'Size > 19 (or > 21 if SDI_Bits_Used = True)

   Sdi_Type_Too_Big : exception;
   -- Sdi_Type'Size > 2

   Ssm_Type_Too_Big : exception;
   -- Ssm_Type'Size > 2

end Arinc_429_Discrete;
