-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- An instantiation of this package provides procedures for packing
-- numeric and discrete data into an ARINC 429 32-bit message, using
-- BNR for the numeric format.
--
-- The first generic formal parameter is the label, which should be
-- supplied as an eight-bit octal number, in the range 8#000# to
-- 8#377#.  The package handles the required reversal of the label.
--
-- The next three instantiation parameters have to do with converting
-- a floating point number into a fixed-point binary number (BNR):
--
-- Value_Type: the type of the numeric value to be packed into the
--      message.  Any floating point type may be used.
--
-- Scale : a number of Value_Type used to scale the floating point
--      value into a fixed-point binary number.
--
-- Significant_Digits: the number of bits used for the fixed-point
--      binary number.  This must be 20 or less.
--
--      To convert a floating point number X into a BNR value B:
--
--              B := X * 2 ** Significant_Digits / Scale;
--
--      If Significant_Digits < 18, the value is padded on the low end.
--      The pad space may be used to store discrete values related to
--      the label.
--
--      If Significant_Digits = 20, the entire data field is used, along
--      with the two bits normally used for the SDI, which contain the
--      least significant two bits of the BNR value.
--
--      The meaning of Scale and Significant_Digits are as used in ARINC
--      429 Spec, table 2, attachment 2.
--
-- Discretes_Type: any type, but Discretes_Type'Size must be less than
--      the number of pad bits (18 - Significant_Digits) to avoid
--      overwriting the numeric value.  The Pack procedure stores a value
--       of Discretes_Type in the ARINC 429 message beginning at bit 11
--      (where the LSB of an ARINC 429 message is defined as bit 1).
--
--      If no discrete data is needed, use a null record type for this parameter.
--
-- Sdi_Type: an enumeration type of no more than 4 values, defining the
--      meaning of the two bits of the Source/Destination Identifier.
--
-- Ssm_Type: an enumeration type of no more than 4 values, defining the
--      meaning of the two bits of the Sign/Status Matrix.
--
-------------------------------------------------------------------------------
with Arinc_429_Types;
generic
   Label : Arinc_429_Types.Octal_Label;
   type Value_Type is digits <>;
   Scale : Value_Type;
   Significant_Digits : Natural;
   type Discretes_Type is private;
   type Sdi_Type is (<>);
   type Ssm_Type is (<>);
package Arinc_429_Bnr is

   function Pack ( A_Value : in Value_Type;
                   A_Sdi : in Sdi_Type;
                   A_Ssm : in Ssm_Type;
                   A_Discretes_Value : in Discretes_Type )
     return Arinc_429_Types.Message_Type;

   procedure Unpack ( A_Message : in Arinc_429_Types.Message_Type;
                      A_Value : out Value_Type;
                      A_Sdi : out Sdi_Type;
                      A_Ssm : out Ssm_Type;
                      A_Discretes_Value : out Discretes_Type );

   -- Exceptions are raised during elaboration of the instantiated package, to
   -- indicate that invalid types were used to instantiate the package.  Wish
   -- we could check this at compile time, but that doesn't seem to be possible.

   Discretes_Type_Too_Big : exception;
   -- Discretes_Type'Size > 18 - Significant_Digits

   Sdi_Type_Too_Big : exception;
   -- Sdi_Type'Size > 2

   Ssm_Type_Too_Big : exception;
   -- Ssm_Type'Size > 2

   Too_Many_Significant_Digits : exception;
   -- Significant_Digits > 20

end Arinc_429_Bnr;
