-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package provides funtionality for creating and maintaining snapshots of
-- the entire system.
-------------------------------------------------------------------------------
package Scheduler.Snapshot is

   type Snapshot_Descriptor is record
      Mission_Time : Duration;
      Latitude     : Long_Float;
      Longitude    : Long_Float;
      Altitude     : Float;
      Heading      : Float;
      Airspeed     : Float;
      Valid        : Boolean := False;
   end record;

   type Snapshot_Index is range 1..20;

   ----------------------------------------------------------------------------
   -- Initialize this facility by allocating each of the snapshot buffers with
   -- enough space to store the given amount of stream elements.
   ----------------------------------------------------------------------------
   procedure Initialize (Snapshot_Size : in Natural);

   ----------------------------------------------------------------------------
   -- Create a snapshot. and return its stream handle. This is a time-consuming
   -- operation, so it needs to be performed from a non-realtime thread.
   ----------------------------------------------------------------------------
   procedure Create;

   ----------------------------------------------------------------------------
   -- Restore the simulation from the given snapshot. This is a time-consuming
   -- operation, so it needs to be performed from a non-realtime thread.
   ----------------------------------------------------------------------------
   procedure Restore (Index : in Snapshot_Index);

   ----------------------------------------------------------------------------
   -- Delete the given snapshot.
   ----------------------------------------------------------------------------
   procedure Delete (Index : in Snapshot_Index);

   ----------------------------------------------------------------------------
   -- Get the descriptor for the snapshot with the given index.
   ----------------------------------------------------------------------------
   function Get_Descriptor (Index : in Snapshot_Index) return Snapshot_Descriptor;

   function Snapshot_Index_Locked return Boolean;

   function Get_Index return Snapshot_Index;

   procedure Set_Index(The_Index : in Snapshot_Index);

   private 
      Locked : Boolean;
      Index  : Snapshot_Index;

end Scheduler.Snapshot;
