-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package allows subsystem schedulers to register themselves with the
-- system for scheduling.
-------------------------------------------------------------------------------
package Scheduler.Registrar is

   ----------------------------------------------------------------------------
   -- Register the given subsystem scheduler for scheduling. The name will be
   -- taken automaticly from the scheduler's tag. This is a bit cheesy, as
   -- the tag is implementation defined. It also prevents multiple schedulers
   -- of the same type. But it does save a parameter, and removes one source
   -- of errors in registration mismatches.
   ----------------------------------------------------------------------------
   procedure Register( The_Handle  : in Scheduler.Handle );

   ----------------------------------------------------------------------------
   -- Retrieve the handle for the subsystem scheduler with the given name.
   -- The search is case-insensitive. A null handle will be returned if it
   -- fails.
   ----------------------------------------------------------------------------
   function Retrieve_Handle (The_Name : String) return Scheduler.Handle;

   ----------------------------------------------------------------------------
   -- Retrieve the name for the given subsystem scheduler. A zero length string
   -- will be returned if the search fails.
   ----------------------------------------------------------------------------
   function Retrieve_Name ( Handle : in Scheduler.Handle) return String;

end Scheduler.Registrar;
