-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package provides the scheduler control over the record/playback
-- functionality.
-------------------------------------------------------------------------------
private package Scheduler.Record_Playback is

   ----------------------------------------------------------------------------
   -- Reset the snapshot counter.
   ----------------------------------------------------------------------------
   procedure Reset;

   ----------------------------------------------------------------------------
   -- Check to see if its time to snapshot all the models yet.
   -- The time is based on the number of previous calls to this routine, and
   -- the value of cycle (which must be 0 for snapshots to occur).
   ----------------------------------------------------------------------------
   function Model_Snapshot_Time (Cycle : Natural) return Boolean;

   -------------------------------------------------------------------------------
   -- Take a snapshot of the state of the given module
   -------------------------------------------------------------------------------
   procedure Snapshot (Module : in out Instance'Class);

   -------------------------------------------------------------------------------
   -- Attempt to restore the state of the given module, if need be.
   -------------------------------------------------------------------------------
   procedure Restore (Module : in out Instance'Class);

end Scheduler.Record_Playback;
