-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with System;

-------------------------------------------------------------------------------
-- This package provides for communicaions of scheduler data with the IOS.
-------------------------------------------------------------------------------
private package Scheduler.IOS_Communications is


   --------------------------
   -- IOS accessed variables

   Host_Update_In_Freeze_Active : Boolean := False;
   Reboot_Request               : Boolean := False;

   -- Contains the total number of cycles that have elapsed since the
   -- simulation was started.
   Total_Number_Of_Cycles : Natural := 0;

   ----------------------------------------------------------------------------
   -- Register IOS accessed variables (see above).
   ----------------------------------------------------------------------------
   procedure Initialize;

   ----------------------------------------------------------------------------
   -- Register the IOS variables for the given thread.
   ----------------------------------------------------------------------------
   procedure Register_Band_Data
     (Band_Name          : in     String;
      Active_Flag_Ptr    : access Boolean;
      Execution_Time_Ptr : access Float
     );

   ----------------------------------------------------------------------------
   -- Register the IOS variables for the named module.
   ----------------------------------------------------------------------------
   procedure Register_Module_Data
     (Real_Time_Module_Name : in     String;
      Active_Flag_Ptr       : access Boolean;
      Execution_Time_Ptr    : access Float
     );

end Scheduler.IOS_Communications;
