-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package implements an abstract definition of a scheduled item for an
-- external IO interface. It is intended for use by scheduled items that
-- bring external inputs into the simulation.
--
-- It differs from a normal scheduler in the following respects:
--
--   o  During normal simulation, Save will be called immediately after every
--      Update (rather than immediately before some of them).
--   o  Save will *not* be called when a snapshot is requested.
--   o  During a replay, Update will *not* be called.
--   o  Update_In_Freeze will be called every iteration during a Replay.
--      During a normal simulation Update (and Save) will be called as normal
--      during a freeze.
--   o  If a freeze (pause) occurs during replay, Restore will not be called.
--
--  The implications of this are:
--    Save should save off all the input data that was read by Update.
--
--    Restore should treat the input data read from the stream as if it had
--    just come from the interface.
--
--    Update_In_Freeze may need to perform IO on the interface to keep
--    communications up or to drive outputs to values that are consistent with
--    the replayed inputs.
--
-------------------------------------------------------------------------------
package Scheduler.IO is

   type Instance is abstract new Scheduler.Instance with private;

private
   type Instance is abstract new Scheduler.Instance with null record;
end Scheduler.IO;
