-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Real_Time;

-------------------------------------------------------------------------------
-- This package implements the simulation's real-time executive scheduler.
-- Once started, it will initialize all registered real-time schedulers and
-- thereafter ensure they update at the configured rates.
-------------------------------------------------------------------------------
package Scheduler.Executive is

   -------------------------------------------------------------------------------
   -- Start scheduling tasks. This should not be called until all the subsystem
   -- schedulers have registered.
   -------------------------------------------------------------------------------
   procedure Start;

   -------------------------------------------------------------------------------
   -- Enable or disable saving of model data. An input value of False indicates
   -- saving is to be disabled. Saving is enabled by default.
   -------------------------------------------------------------------------------
   procedure Enable_Saving ( Enable : in Boolean := True);

   -------------------------------------------------------------------------------
   -- Put the scheduler into freeze. This will cause the registered schedulers to
   -- have their Update_In_Freeze routines called rather than their Update
   -- routines.
   -------------------------------------------------------------------------------
   procedure Freeze (On : in Boolean := True);

   -------------------------------------------------------------------------------
   -- Empty out all the replay buffers for all the schedulers.
   -------------------------------------------------------------------------------
   procedure Flush_All_Replay_Buffers;

   -------------------------------------------------------------------------------
   -- Return the last cycle executed (in the range 0 ..
   -- Scheduler.Configuration.Cycles_Per_Frame - 1).
   -------------------------------------------------------------------------------
   function Last_Cycle return Natural;

   -------------------------------------------------------------------------------
   -- Terminate the current freeze condition (if one exists) on the next cycle of
   -- the given value.
   -------------------------------------------------------------------------------
   procedure Thaw_On_Cycle (Cycle : in Natural);

end Scheduler.Executive;
