-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Real_Time;
with Simulation_Dictionary;

pragma Elaborate_All (Simulation_Dictionary);

-------------------------------------------------------------------------------
-- This package provides the simulation scheduler's startup configuration.
-------------------------------------------------------------------------------
package Scheduler.Configuration is

   Bad : exception;

   ----------------------------------------------------------------------------
   -- Unconfigurable Items.
   -- The items below may be changed here in the source code, but will not be
   -- configured at runtime.

   -- The amount of time to wait between model snapshots
   Snapshot_Period : constant Ada.Real_Time.Time_Span
     := Ada.Real_Time.To_Time_Span(Duration(Integer'(Simulation_Dictionary.Lookup ("Snapshot_Period"))));

   ----------------------------------------------------------------------------
   -- Configurable Items.
   -- The initialized values are meerly defaults. They are typically to new
   -- values by Initialize.

   -- Defines the length of one cycle.
   Cycle_Length : Float := 1.0 / 240.0;

   -- Defines the number of execution cycles per frame (second).
   Cycles_Per_Frame : Positive := 240;

   -------------------------------------------------------------------------------
   -- Return the time required for every model to run once.
   -------------------------------------------------------------------------------
   function Simulation_Frequency return Ada.Real_Time.Time_Span;

   -------------------------------------------------------------------------------
   -- Initialize the scheduler's configuration. This is accomplished by reading
   -- and parsing the file "sim.cfg" in the current working directory.
   -------------------------------------------------------------------------------
   procedure Initialize;

end Scheduler.Configuration;
