-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- This package provides the mission time. Mission time is the amount of
-- seconds that have elapsed since mission time was last reset.
-- Values of type Duration are used to externally represent mission time. Ada
-- specifies that Duration must support representation of at least an entire
-- day in units at least as small as 20ms.
-------------------------------------------------------------------------------
package Mission_Time is

   ----------------------------------------------------------------------------
   -- Reset the mission time to the given amount of seconds.
   ----------------------------------------------------------------------------
   procedure Reset (To : in Duration := 0.0);

   ----------------------------------------------------------------------------
   -- Return the current mission time (in seconds).
   ----------------------------------------------------------------------------
   function Get return Duration;

   ----------------------------------------------------------------------------
   -- Update the IOS's value for the mission time.
   ----------------------------------------------------------------------------
   procedure Update;

   ----------------------------------------------------------------------------
   -- Initialize this facility. This will reset the mission time to 0 seconds
   -- and register the appropriate IOS variables.
   ----------------------------------------------------------------------------
   procedure Initialize;

end Mission_Time;
