-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                      JPATS T-6A Flight Training Device
--
--
--  Engineer:  Ted E. Dennison
--
--  Revision:
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

-- The simulation models used
with JPATS_Aircraft_Body.Scheduler;
with JPATS_Atmosphere.Free_Air_Scheduler;
with JPATS_Atmosphere.Winds_Scheduler;
with JPATS_Atmosphere.Microburst_Scheduler;
with JPATS_Auto_test.Scheduler;
with JPATS_Avionics.Scheduler;
with JPATS_Avionics.Rmu_Scheduler;
with JPATS_Simphonics.Scheduler;
with JPATS_DCLS.Scheduler;
with JPATS_Electrical.Scheduler;
with JPATS_Environmental.Scheduler;
with JPATS_Flight_Instruments.Scheduler;
with JPATS_Flight_Instruments.AOA_System_Scheduler;
with JPATS_Formation_Manager.Scheduler;
with JPATS_Formation_Profile_Recorder.Scheduler;
with JPATS_Formation_Profile_Playback.Scheduler;
with JPATS_Fuel.Scheduler;
with JPATS_HostComms_Scheduler;
with JPATS_Hydraulics.Scheduler;
with JPATS_IOS_Pilot.Scheduler;
with JPATS_Landing_Gear.Scheduler;
with JPATS_Lights.Scheduler;
with JPATS_Nav_Instruments.Scheduler;
with JPATS_Powerplant.Scheduler;
with JPATS_Propeller.Scheduler;
with JPATS_Engine_Data_Manager.Scheduler;
with JPATS_Radio.Scheduler;
with JPATS_Radio_DB_IF.Scheduler;
with JPATS_Reposition.Scheduler;
with JPATS_Scu.Scheduler;
with JPATS_Secondary_Flight_Controls.Scheduler;
with JPATS_Secondary_Flight_Controls.Rudder_Trim_Scheduler;
with JPATS_Simulated_Aircraft.Scheduler;
with JPATS_Simulated_Aircraft.Mass_Property_Scheduler;
with JPATS_Visual_Airport.Scheduler;
with JPATS_Visual_Buffer.Slow_Data_Scheduler;
with JPATS_Visual_Buffer.Fast_Data_Scheduler;
with JPATS_Visual_Models.Scheduler;
with JPATS_Visual_Weather.Scheduler;
with JPATS_Warning.Scheduler;
with JPATS_IO.Scheduler;

-- The main scheduler
with Scheduler.Executive;

-- Initilization of the IOS interface
with JPATS_IOS_Interface;

-- For logging fatal exceptions
with Log;
with Ada.Exceptions;
with Ada.Characters.Latin_1;


-------------------------------------------------------------------------------
-- This routine is the main entry point for the JPATS simulation. All the work
-- is done in subtasks kicked off by the *_Module packages above. Thus there's
-- really no actual code in this file.
-------------------------------------------------------------------------------
procedure JPATS is
   EOL : constant String := Ada.Characters.Latin_1.CR & Ada.Characters.Latin_1.LF;
begin

   JPATS_IOS_Interface.Initialize;
   Scheduler.Executive.Start;

exception

   when Error : others =>

      Log.Report (Event    => "Main task terminated due to unhandled exception" & EOL &
                               Ada.Exceptions.Exception_Information (Error),
                  Severity => Log.Fatal);
end JPATS;

