-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;
with Length_Types;

package Velocity is

   type Instance is private;

   --| calc Velocity in Body axis coordinates
   procedure Set_Body_Axis(Roll_Angle   :in     Angle_Types.Radians;
                           Pitch_Angle  :in     Angle_Types.Radians;
                           Hdg_Angle    :in     Angle_Types.Radians;
                           North_Vel    :in     Length_Types.Feet_Per_Sec;
                           east_Vel     :in     Length_Types.Feet_Per_Sec;
                           vert_Vel     :in     Length_Types.Feet_Per_Sec;
                           An_Instance  :in out Instance);

   --| Xform Inertial Velocity into Body axis (north-east to body x-y)
   procedure Set_Inertial(Roll_Angle            :in     Angle_Types.Radians;
                          Pitch_Angle           :in     Angle_Types.Radians;
                          hdg_Angle             :in     Angle_Types.Radians;
                          An_Instance           :in out Instance) ;

   procedure Assign_Inertial
        (Inertial_Vel :in     Coordinate_Types.Cartesian;
         An_Instance  :in out Instance);

   function Get_Inertial(An_Instance :in Instance)
                       return Coordinate_Types.Cartesian;


   procedure Set_Body_Axis_based_on_True_Airspeed
     (Tas              :in      Length_Types.Feet_per_Sec;
      Aoa              :in      Angle_Types.Radians;
      Side_Slip_Angle  :in      Angle_Types.Radians;
      An_Instance      :in  out Instance);

   procedure Assign_Body_Axis(Init_V_B    :in     Coordinate_Types.Cartesian;
                              An_Instance :in out Instance);

   function Get_Body_Axis(An_Instance :in Instance)
             return Coordinate_Types.Cartesian;

   --| calc Velocity in Earth axis coordinate system
   procedure Set_Earth_Axis
               (Accel_Earth_Axis   : in      Coordinate_Types.Cartesian;
                lp_accel_ea        : in      Coordinate_Types.Cartesian;
                Dt                 : in      Float;
                Stopped            : in      Boolean;
                An_Instance        : in  out Instance);

   --| To be used during formation flying for lead aircraft.
   procedure Set_Body_to_Earth_Axis
       (Roll_Angle         :in     Angle_Types.Radians;
        Pitch_Angle        :in     Angle_Types.Radians;
        Yaw_Angle          :in     Angle_Types.Radians;
        North_Wind         :in     Length_Types.Feet_per_Sec;
        east_Wind          :in     Length_Types.Feet_per_Sec;
        vertical_Wind      :in     Length_Types.Feet_per_Sec;
        An_Instance        :in out Instance);

   procedure Assign_Earth_Axis
          (Vel_Earth_Axis           :in      Coordinate_Types.Cartesian;
           Last_Pass_Vel_Earth_Axis :in      Coordinate_Types.Cartesian;
           An_Instance              :in  out Instance);

   function Get_Earth_Axis(An_Instance :in Instance)
              return Coordinate_Types.Cartesian;

   function Get_Last_Pass_Earth_Axis(An_Instance :in Instance)
              return Coordinate_Types.Cartesian;

   procedure Set_Roll_Rate
     (Roll_Accel              :in     Angle_Types.Radians_per_Sq_Sec;
      Last_Pass_Roll_Accel    :in     Angle_Types.Radians_per_Sq_Sec;
      dt                      :in     Float;
      An_Instance             :in out Instance);

   procedure Assign_Roll_Rate
          (Roll_Rate     :in     Angle_Types.Radians_per_Sec;
           An_Instance   :in out Instance);

   function Get_Roll_Rate (An_Instance :in Instance)
              return Angle_Types.Radians_per_Sec;

   procedure Set_Pitch_Rate
         (Pitch_Accel            :in     Angle_Types.Radians_per_Sq_Sec;
          Last_Pass_Pitch_Accel  :in     Angle_Types.Radians_per_Sq_Sec;
          dt                     :in     Float;
          An_Instance            :in out Instance);

   procedure Assign_Pitch_Rate
         (Pitch_Rate    :in     Angle_Types.Radians_per_Sec;
          An_Instance   :in out Instance);

   function Get_Pitch_Rate (An_Instance :in Instance)
             return Angle_Types.Radians_per_Sec;

   procedure Set_Yaw_Rate
      (Yaw_Accel             :in     Angle_Types.Radians_per_Sq_Sec;
       Last_Pass_Yaw_Accel   :in     Angle_Types.Radians_per_Sq_Sec;
       dt                    :in     Float;
       An_Instance           :in out Instance);

   procedure Assign_Yaw_Rate
        (Yaw_Rate    :in     Angle_Types.Radians_per_Sec;
         An_Instance :in out Instance);

   function Get_Yaw_Rate (An_Instance :in Instance)
         return Angle_Types.Radians_per_Sec;

   procedure Set_Nondimensional_Angular
     (Span_Wing        :in     Length_Types.Feet;
      Chord_Wing       :in     Length_Types.Feet;
      Tas              :in     Length_Types.Feet_per_Sec;
      Aoa              :in     Angle_Types.Radians;
      An_Instance      :in out Instance);

   procedure Assign_Nondimensional_Angular
     (ND_Angular_Rate   :in     Coordinate_Types.Attitude;
      An_Instance       :in out Instance);

   function Get_Nondimensional_Angular(An_Instance :in Instance) return Coordinate_Types.Attitude;

   function direction (An_Instance :in Instance) return angle_Types.Radians;

private
   type Instance is
      record
          The_Inertial_Vel             : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
          The_Vel_Body_Axis            : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
          The_Vel_Earth_Axis           : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
          The_Last_Pass_Vel_Earth_Axis : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
          The_Roll_Rate                : Angle_Types.Radians_per_Sec := 0.0;
          The_Pitch_Rate               : Angle_Types.Radians_per_Sec := 0.0;
          The_Yaw_Rate                 : Angle_Types.Radians_per_Sec := 0.0;
          The_Last_Pass_Roll_Rate      : Angle_Types.Radians_per_Sec := 0.0;
          The_Last_Pass_Pitch_Rate     : Angle_Types.Radians_per_Sec := 0.0;
          The_Last_Pass_Yaw_Rate       : Angle_Types.Radians_per_Sec := 0.0;
          The_Nondimensional_Angular   : Coordinate_Types.Attitude := (0.0,0.0,0.0);
          Direction                    : angle_Types.Radians := 0.0;
      end record;
end Velocity;
