-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Coordinate_Types;
with Length_Types;
with Normalized_Types;
with Mass_Types;

package Reference_Coordinates is

   type Instance is private;

   procedure Set_Zero_Fuel
     (Basic          :in     Coordinate_Types.Reference_System;
      Baggage        :in     Coordinate_Types.Reference_System;
      Student        :in     Coordinate_Types.Reference_System;
      Instructor     :in     Coordinate_Types.Reference_System;
      ZF_Wt          :in     Mass_Types.Lbm;
      Wt_Basic       :in     Mass_Types.Lbm;
      Wt_Student     :in     Mass_Types.Lbm;
      Wt_instructor  :in     Mass_Types.Lbm;
      Wt_Baggage     :in     Mass_Types.Lbm;
      An_Instance    :in out Instance);

   function Get_Zero_Fuel(An_Instance :in Instance) return Coordinate_Types.Reference_System;

   procedure Set_Y_CG
     (ZF_Wt            :in     Mass_Types.Lbm;
      GW               :in     Mass_Types.Lbm;
      Fuel_Y_cg        :in     Length_Types.Feet;
      An_Instance      :in out Instance);
   procedure Assign_Y_CG
     (Cg_Bl            :in     Length_Types.Feet;
      An_Instance      :in out Instance);
   function Get_Y_CG(An_Instance :in Instance) return Length_Types.Feet;

   procedure Set_X_Cg
     (ZF_Wt              :in     Mass_Types.Lbm;
      GW                 :in     Mass_Types.Lbm;
      Fuel_X_Cg          :in     Length_Types.Feet;
      Lg_Pos             :in     Normalized_Types.Normalize;
      An_Instance        :in out Instance);

   procedure Compute_Cg_Pct_MAC(An_Instance        :in out Instance);

   function Cg_pct(An_Instance :in Instance) return Normalized_Types.Normalize;
   procedure Assign_X_CG
     (Cg_Fs           :in     Length_Types.Feet;
      An_Instance     :in out Instance);
   function Get_X_CG(An_Instance :in Instance) return Length_Types.Feet;

   procedure Set_Z_CG
     (ZF_Wt           :in     Mass_Types.Lbm;
      GW              :in     Mass_Types.Lbm;
      Fuel_Z_cg       :in     Length_Types.Feet;
      Lg_Pos          :in     Normalized_Types.Normalize;
      An_Instance     :in out Instance);

   procedure Assign_Z_CG
     (Cg_Wl           : in Length_Types.Feet;
      An_Instance     :in out Instance);
   function Get_Z_CG(An_Instance :in Instance) return Length_Types.Feet;

private
   type Instance is
      record
         The_Zero_Fuel    : Coordinate_Types.Reference_System :=(13.741,0.006,7.425);
         Y_CG             : Length_Types.Feet := 0.006;
         X_CG             : Length_Types.Feet := 13.741;
         Z_CG             : Length_Types.Feet := 7.425;
         CG_Mac           : Normalized_Types.normalize;
      end record;

end Reference_Coordinates;





