-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Divisiona
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
package body Reference_Coordinates is

   procedure Set_Zero_Fuel (Basic          :in     Coordinate_Types.Reference_System;
                            Baggage        :in     Coordinate_Types.Reference_System;
                            Student        :in     Coordinate_Types.Reference_System;
                            Instructor     :in     Coordinate_Types.Reference_System;
                            ZF_Wt          :in     Mass_Types.Lbm;
                            Wt_Basic       :in     Mass_Types.Lbm;
                            Wt_Student     :in     Mass_Types.Lbm;
                            Wt_instructor  :in     Mass_Types.Lbm;
                            Wt_Baggage     :in     Mass_Types.Lbm;
                            An_Instance    :in out Instance) is
   begin
      An_Instance.The_Zero_Fuel.Bl   := (Wt_Basic * Basic.Bl) / Float'Max(ZF_Wt,0.1);

      An_Instance.The_Zero_Fuel.Fs := (Wt_Basic * Basic.Fs + Wt_Student * Student.Fs
                  + Wt_Instructor * Instructor.Fs + Wt_Baggage * Baggage.Fs)
                                                                 / Float'Max(ZF_Wt,0.1);
      An_Instance.The_Zero_Fuel.Wl := (Wt_Basic * Basic.Wl + Wt_Student * Student.Wl
                  + Wt_Instructor * Instructor.Wl + Wt_Baggage * Baggage.Wl)
                                                                / Float'Max(ZF_Wt,0.1);
   end Set_Zero_Fuel;

   function Get_Zero_Fuel(An_Instance :in Instance) return Coordinate_Types.Reference_System is
   begin
      return An_Instance.The_Zero_Fuel;
   end Get_Zero_Fuel;

   procedure Set_Y_CG
     (ZF_Wt            :in     Mass_Types.Lbm;
      GW               :in     Mass_Types.Lbm;
      Fuel_Y_cg        :in     Length_Types.Feet;
      An_Instance      :in out Instance) is
   begin
      An_Instance.Y_CG := (ZF_Wt * An_Instance.The_Zero_Fuel.Bl +
                       (Gw - ZF_Wt) * Fuel_Y_cg) / Float'Max(GW,0.1);
   end Set_Y_CG;

   --| procedure to input CG during autotesting

      procedure Assign_Y_CG
     (Cg_BL         :in     Length_Types.Feet;
      An_Instance   :in out Instance) is
   begin
      An_Instance.Y_CG :=Cg_BL;
   end Assign_Y_CG;

   procedure Assign_X_CG
     (CG_Fs          :in     Length_Types.Feet;
      An_Instance    :in out Instance) is
   begin
      An_Instance.X_CG := Cg_Fs;
   end Assign_X_CG;

   procedure Assign_Z_CG
     (Cg_WL          :in     Length_Types.Feet;
      An_Instance    :in out Instance) is
   begin
      An_Instance.Z_CG:= Cg_Wl;
   end Assign_Z_CG;

   function Get_Y_CG(An_Instance :in Instance) return Length_Types.Feet is
   begin
      return An_Instance.Y_CG;
   end Get_Y_CG;

   procedure Set_X_CG
     (ZF_Wt              :in     Mass_Types.Lbm;
      GW                 :in     Mass_Types.Lbm;
      Fuel_X_Cg          :in     Length_Types.Feet;
      Lg_Pos             :in     Normalized_Types.Normalize;
      An_Instance        :in out Instance) is
   begin
      An_Instance.X_CG := (ZF_Wt * An_Instance.The_Zero_Fuel.Fs + 251.0 *
                 (1.0 - Lg_Pos) +(Gw - ZF_Wt) *  Fuel_X_CG) / Float'Max(GW,0.1);
   end Set_X_CG;

   function Cg_pct(An_Instance :in Instance) return Normalized_Types.Normalize is
       begin
           return An_Instance.Cg_Mac;
   end Cg_Pct;

   function Get_X_CG(An_Instance :in Instance) return Length_Types.Feet is
   begin
      return An_Instance.X_CG;
   end Get_X_CG;

   procedure Set_Z_CG
     (ZF_Wt           :in     Mass_Types.Lbm;
      GW              :in     Mass_Types.Lbm;
      Fuel_Z_cg       :in     Length_Types.Feet;
      Lg_Pos          :in     Normalized_Types.Normalize;
      An_Instance     :in out Instance) is
   begin
      An_Instance.Z_CG := (ZF_Wt * An_Instance.The_Zero_Fuel.Wl + 517.0 *
             (1.0 - Lg_Pos) + (Gw - ZF_Wt) * Fuel_Z_cg) / Float'Max(GW,0.1);
   end Set_Z_CG;

   function Get_Z_CG(An_Instance :in Instance) return Length_Types.Feet is
   begin
      return An_Instance.Z_CG;
   end Get_Z_CG;

 --| Compute CG as a pct of the MAC
   procedure Compute_Cg_Pct_MAC (An_Instance  :in out Instance)is
   begin
        An_Instance.Cg_mac :=(An_Instance.X_Cg-12.705)/5.413 * 100.0;
   end Compute_Cg_Pct_Mac;
end Reference_Coordinates;





