-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;

package Quaternion is

   type Instance is private;

   procedure Set_Quaternion_Rate (Roll_Rate  :in  Angle_Types.Radians_per_Sec;
                                  Pitch_Rate :in  Angle_Types.Radians_per_Sec;
                                  Yaw_Rate   :in  Angle_Types.Radians_per_Sec;
                                  An_Instance  :in out Instance);

   procedure Set_Quaternion (Int_Time     :in     Float;
                             Freeze_Time  :in     Float;
                             An_Instance  :in out Instance);

   procedure Set_Quat_From_angles
     (Roll_Angle  :in     Angle_Types.Radians;
      Pitch_Angle :in     Angle_Types.Radians;
      Yaw_Angle   :in     Angle_Types.Radians;
      An_Instance :in out Instance);

   function Get_L_1(An_Instance :in Instance) return Float;
   function Get_L_2(An_Instance :in Instance) return Float;
   function Get_L_3(An_Instance :in Instance) return Float;

   function Get_M_1(An_Instance :in Instance) return Float;
   function Get_M_2(An_Instance :in Instance) return Float;
   function Get_M_3(An_Instance :in Instance) return Float;

   function Get_N_1(An_Instance :in Instance) return Float;
   function Get_N_2(An_Instance :in Instance) return Float;
   function Get_N_3(An_Instance :in Instance) return Float;

private
   type Instance is
      record
         The_Q1_Dot             : Float:= 0.0;
         The_Q2_Dot             : Float:= 0.0;
         The_Q3_Dot             : Float:= 0.0;
         The_Q4_Dot             : Float:= 0.0;

         The_Q1                 : Float:= 1.0;
         The_Q2                 : Float:= 0.0;
         The_Q3                 : Float:= 0.0;
         The_Q4                 : Float:= 0.0;

         The_L_1                : Float:= 1.0;
         The_L_2                : Float:= 0.0;
         The_L_3                : Float:= 0.0;

         The_M_1                : Float:= 0.0;
         The_M_2                : Float:= 1.0;
         The_M_3                : Float:= 0.0;

         The_N_1                : Float:= 0.0;
         The_N_2                : Float:= 0.0;
         The_N_3                : Float:= 1.0;

         The_Old_Q1_Dot         : Float := 0.0;
         The_Old_Q2_Dot         : Float := 0.0;
         The_Old_Q3_Dot         : Float := 0.0;
         The_Old_Q4_Dot         : Float := 0.0;
      end record;
end Quaternion;
