-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
------------------------------------------------------------------------------
with Ada.Numerics.Elementary_Functions;
use Ada.Numerics.Elementary_Functions;

package body Quaternion is

   procedure Set_Quaternion_Rate (Roll_Rate   :in  Angle_Types.Radians_per_Sec;
                                  Pitch_Rate  :in  Angle_Types.Radians_per_Sec;
                                  Yaw_Rate    :in  Angle_Types.Radians_per_Sec;
                                  An_Instance :in out Instance) is
   begin
      An_Instance.The_Q1_dot := 0.5 * (- An_Instance.The_Q4 * Roll_Rate
                                       - An_Instance.The_Q3 * Pitch_Rate
                                       - An_Instance.The_Q2 * Yaw_Rate);
      An_Instance.The_Q2_dot := 0.5 * (-An_Instance.The_Q3 * Roll_Rate
                                       + An_Instance.The_Q4 * Pitch_Rate
                                       + An_Instance.The_Q1 * Yaw_Rate);
      An_Instance.The_Q3_dot := 0.5 * (+ An_Instance.The_Q2 * Roll_Rate
                                       + An_Instance.The_Q1 * Pitch_Rate
                                       - An_Instance.The_Q4 * Yaw_Rate);
      An_Instance.The_Q4_Dot := 0.5 * (+ An_Instance.The_Q1 * Roll_Rate
                                       - An_Instance.The_Q2 * Pitch_Rate
                                       + An_Instance.The_Q3 * Yaw_Rate);
   end Set_Quaternion_Rate;

   procedure Set_Quaternion (Int_time    :in     Float;
                             Freeze_time :in     Float;
                             An_Instance :in out Instance) is
      Norm_Fac : Float;
   begin
      An_Instance.The_Q1 := An_Instance.The_Q1 +
              0.5 * (An_Instance.The_Q1_Dot + An_Instance.The_Old_Q1_Dot)
                      * Freeze_time;
      An_Instance.The_Q2 := An_Instance.The_Q2 +
              0.5 * (An_Instance.The_Q2_Dot + An_Instance.The_Old_Q2_Dot)
                      * Freeze_time;
      An_Instance.The_Q3 := An_Instance.The_Q3 +
              0.5 * (An_Instance.The_Q3_Dot + An_Instance.The_Old_Q3_Dot)
                      * Int_time;
      An_Instance.The_Q4 := An_Instance.The_Q4 +
              0.5 * (An_Instance.The_Q4_Dot + An_Instance.The_Old_Q4_Dot)
                      * Int_time;
      Norm_Fac := 1.0/Sqrt  (An_Instance.The_Q1 * An_Instance.The_Q1
                           + An_Instance.The_Q2 * An_Instance.The_Q2
                           + An_Instance.The_Q3 * An_Instance.The_Q3
                           + An_Instance.The_Q4 * An_Instance.The_Q4);
      An_Instance.The_Old_q1_dot := An_Instance.The_q1_dot;
      An_Instance.The_old_q2_dot := An_Instance.The_q2_dot;
      An_Instance.The_old_q3_dot := An_Instance.The_q3_dot;
      An_Instance.The_Old_q4_dot := An_Instance.The_q4_dot;

      An_Instance.The_Q1  := An_Instance.The_Q1 * Norm_Fac;
      An_Instance.The_Q2  := An_Instance.The_Q2 * Norm_Fac;
      An_Instance.The_Q3  := An_Instance.The_Q3 * Norm_Fac;
      An_Instance.The_Q4  := An_Instance.The_Q4 * Norm_Fac;

      An_Instance.The_L_1 := An_Instance.The_Q1 * An_Instance.The_Q1
                           - An_Instance.The_Q2 * An_Instance.The_Q2
                           - An_Instance.The_Q3 * An_Instance.The_Q3
                           + An_Instance.The_Q4 * An_Instance.The_Q4;

      An_Instance.The_L_2 := 2.0 * (An_Instance.The_Q1 * An_Instance.The_Q2
                                  + An_Instance.The_Q3 * An_Instance.The_Q4);
      An_Instance.The_L_3 := 2.0 * (An_Instance.The_Q2 * An_Instance.The_Q4
                                  - An_Instance.The_Q1 * An_Instance.The_Q3);
      An_Instance.The_M_1 := 2.0 * (An_Instance.The_Q3 * An_Instance.The_Q4
                                  - An_Instance.The_Q1 * An_Instance.The_Q2);
      An_Instance.The_M_2 := An_Instance.The_Q1 * An_Instance.The_Q1
                           - An_Instance.The_Q2 * An_Instance.The_Q2
                           + An_Instance.The_Q3 * An_Instance.The_Q3
                           - An_Instance.The_Q4 * An_Instance.The_Q4;
      An_Instance.The_M_3 := 2.0 * (An_Instance.The_Q2 * An_Instance.The_Q3
                                  + An_Instance.The_Q1 * An_Instance.The_Q4);
      An_Instance.The_N_1 := 2.0 * (An_Instance.The_Q1 * An_Instance.The_Q3
                                  + An_Instance.The_Q2 * An_Instance.The_Q4);
      An_Instance.The_N_2 := 2.0 * (An_Instance.The_Q2 * An_Instance.The_Q3
                                  - An_Instance.The_Q1 * An_Instance.The_Q4);
      An_Instance.The_N_3 := An_Instance.The_Q1 * An_Instance.The_Q1
                           + An_Instance.The_Q2 * An_Instance.The_Q2
                           - An_Instance.The_Q3 * An_Instance.The_Q3
                           - An_Instance.The_Q4 * An_Instance.The_Q4;
   end Set_Quaternion;

   procedure Set_Quat_From_angles
     (Roll_Angle    :in     Angle_Types.Radians;
      Pitch_Angle   :in     Angle_Types.Radians;
      Yaw_Angle     :in     Angle_Types.Radians;
      An_Instance   :in out Instance) is

      Sine_Roll    : Float := 0.0;
      Cosine_Roll  : Float := 0.0;
      Sine_Pitch   : Float := 0.0;
      Cosine_Pitch : Float := 0.0;
      Sine_Yaw     : Float := 0.0;
      Cosine_Yaw   : Float := 0.0;
   begin

      Sine_Roll    := Sin(0.5 * Roll_Angle );
      Cosine_Roll  := Cos(0.5 * Roll_Angle );
      Sine_Pitch   := Sin(0.5 * Pitch_Angle);
      Cosine_Pitch := Cos(0.5 * Pitch_Angle);
      Sine_Yaw     := Sin(0.5 * Yaw_Angle  );
      Cosine_Yaw   := Cos(0.5 * Yaw_Angle  );

      An_Instance.The_Q1  :=  Cosine_Yaw * Cosine_Pitch * Cosine_Roll +
                              Sine_Yaw * Sine_Pitch   * Sine_Roll;
      An_Instance.The_Q2  := -Cosine_Yaw * Sine_Pitch   * Sine_Roll   +
                              Sine_Yaw * Cosine_Pitch * Cosine_Roll;
      An_Instance.The_Q3  :=  Cosine_Yaw * Sine_Pitch   * Cosine_Roll +
                              Sine_Yaw * Cosine_Pitch * Sine_Roll;
      An_Instance.The_Q4  :=  Cosine_Yaw * Cosine_Pitch * Sine_Roll   -
                              Sine_Yaw * Sine_Pitch   * Cosine_Roll;

      An_Instance.The_L_1 := An_Instance.The_Q1 * An_Instance.The_Q1
                           - An_Instance.The_Q2 * An_Instance.The_Q2
                           - An_Instance.The_Q3 * An_Instance.The_Q3
                           + An_Instance.The_Q4 * An_Instance.The_Q4;

      An_Instance.The_L_2 := 2.0 * (An_Instance.The_Q1 * An_Instance.The_Q2
                                  + An_Instance.The_Q3 * An_Instance.The_Q4);
      An_Instance.The_L_3 := 2.0 * (An_Instance.The_Q2 * An_Instance.The_Q4
                                  - An_Instance.The_Q1 * An_Instance.The_Q3);
      An_Instance.The_M_1 := 2.0 * (An_Instance.The_Q3 * An_Instance.The_Q4
                                  - An_Instance.The_Q1 * An_Instance.The_Q2);
      An_Instance.The_M_2 := An_Instance.The_Q1 * An_Instance.The_Q1
                           - An_Instance.The_Q2 * An_Instance.The_Q2
                           + An_Instance.The_Q3 * An_Instance.The_Q3
                           - An_Instance.The_Q4 * An_Instance.The_Q4;
      An_Instance.The_M_3 := 2.0 * (An_Instance.The_Q2 * An_Instance.The_Q3
                                  + An_Instance.The_Q1 * An_Instance.The_Q4);
      An_Instance.The_N_1 := 2.0 * (An_Instance.The_Q1 * An_Instance.The_Q3
                                  + An_Instance.The_Q2 * An_Instance.The_Q4);
      An_Instance.The_N_2 := 2.0 * (An_Instance.The_Q2 * An_Instance.The_Q3
                                  - An_Instance.The_Q1 * An_Instance.The_Q4);
      An_Instance.The_N_3 := An_Instance.The_Q1 * An_Instance.The_Q1
                           + An_Instance.The_Q2 * An_Instance.The_Q2
                           - An_Instance.The_Q3 * An_Instance.The_Q3
                           - An_Instance.The_Q4 * An_Instance.The_Q4;
   end Set_Quat_From_angles;

   function Get_L_1(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_L_1;
   end Get_L_1;

   function Get_L_2(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_L_2;
   end Get_L_2;

   function Get_L_3(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_L_3;
   end Get_L_3;

   function Get_M_1(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_M_1;
   end Get_M_1;

   function Get_M_2(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_M_2;
   end Get_M_2;

   function Get_M_3(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_M_3;
   end Get_M_3;

   function Get_N_1(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_N_1;
   end Get_N_1;

   function Get_N_2(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_N_2;
   end Get_N_2;

   function Get_N_3(An_Instance :in Instance) return float is
   begin
      return An_Instance.The_N_3;
   end Get_N_3;

end Quaternion;
