-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Coordinate_Types;
with Normalized_Types;
with Mass_Types;

package Moment_of_Inertia is

   type Instance is private;

   procedure Set_Inertia
     (moi_basic          :in     Coordinate_Types.Inertia_Axis;
      moi_fuel           :in     Coordinate_Types.Inertia_Axis;
      Wt_Zero_Fuel       :in     Mass_Types.Lbm;
      Wt_Basic           :in     Mass_Types.Lbm;
      Wt_Stud            :in     Mass_Types.Lbm;
      Wt_Inst            :in     Mass_Types.Lbm;
      Wt_Baggage         :in     Mass_Types.Lbm;
      origin             :in     Coordinate_Types.Reference_System;
      stud_loc           :in     Coordinate_Types.Reference_System;
      inst_loc           :in     Coordinate_Types.Reference_System;
      Baggage_loc        :in     Coordinate_Types.Reference_System;
      Cg_loc             :in     Coordinate_Types.Reference_System;
      Zf_cg              :in     Coordinate_Types.Reference_System;
      Lg_pos             :in     Normalized_Types.Normalize;
      An_Instance        :in out Instance) ;

   procedure Assign_Inertia (Moi            :in     Coordinate_Types.Inertia_Axis;
                             An_Instance    :in out Instance);

   function Get_Inertia(An_Instance :in Instance) return Coordinate_Types.Inertia_Axis ;

private
   type Instance is
      record
         The_Inertia : Coordinate_Types.Inertia_Axis := (2246.0,6444.0,8008.0,253.0);
      end record;

end Moment_of_Inertia;
