-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
package body Moment_of_Inertia is

   procedure Set_Inertia
     (moi_basic          :in     Coordinate_Types.Inertia_Axis;
      moi_fuel           :in     Coordinate_Types.Inertia_Axis;
      Wt_Zero_Fuel       :in     Mass_Types.Lbm;
      Wt_Basic           :in     Mass_Types.Lbm;
      Wt_Stud            :in     Mass_Types.Lbm;
      Wt_Inst            :in     Mass_Types.Lbm;
      Wt_Baggage         :in     Mass_Types.Lbm;
      origin             :in     Coordinate_Types.Reference_System;
      stud_loc           :in     Coordinate_Types.Reference_System;
      inst_loc           :in     Coordinate_Types.Reference_System;
      Baggage_loc        :in     Coordinate_Types.Reference_System;
      Cg_loc             :in     Coordinate_Types.Reference_System;
      Zf_cg              :in     Coordinate_Types.Reference_System;
      Lg_pos             :in     Normalized_Types.Normalize;
      An_Instance        :in out Instance) is
          Inertia : Coordinate_Types.Inertia_Axis;
   begin
      Inertia.xx := moi_basic.xx +
          (Wt_Basic * ((origin.BL - ZF_CG.BL)**2 + (ZF_CG.WL - origin.WL)**2) +
           Wt_Stud * (0.986 + ZF_CG.Bl **2 + (ZF_CG.WL - stud_loc.WL)**2) +
           Wt_Inst * (0.986 + ZF_CG.BL **2 + (ZF_CG.WL - inst_loc.WL)**2) +
           Wt_Baggage * (ZF_CG.BL **2 + (ZF_CG.WL - baggage_loc.WL)**2))/32.174;

      Inertia.yy := moi_basic.yy +
          (Wt_Basic * ((ZF_CG.FS - origin.FS)**2 + (ZF_CG.WL - origin.WL)**2) +
           Wt_Stud * (1.069 + (ZF_CG.FS - stud_loc.FS)**2 + (ZF_CG.WL - stud_loc.WL)**2) +
           Wt_Inst * (1.069 + (ZF_CG.FS - inst_loc.FS)**2 + (ZF_CG.WL - inst_loc.WL)**2) +
           Wt_Baggage * ((ZF_CG.FS - baggage_loc.FS)**2 + (ZF_CG.WL - baggage_loc.WL)**2))/32.174;

      Inertia.zz := moi_basic.zz +
          (Wt_Basic * ((origin.BL - ZF_CG.BL)**2 + (ZF_CG.FS - origin.FS)**2) +
           Wt_stud * (0.541 + (ZF_CG.BL**2 ) + (ZF_CG.FS - stud_loc.FS)**2) +
           Wt_inst * (0.541 + (ZF_CG.BL**2) + (ZF_CG.FS - inst_loc.FS)**2) +
           Wt_Baggage * ((ZF_CG.BL**2) + (ZF_CG.FS - baggage_loc.FS)**2))/32.174;

      Inertia.xz := moi_basic.xz +
          (Wt_Basic * ((ZF_CG.FS - origin.FS) * (ZF_CG.WL - origin.WL)) +
           Wt_Stud * ((ZF_CG.FS - stud_loc.FS) * (ZF_CG.WL - stud_loc.WL)) +
           Wt_Inst * ((ZF_CG.FS - inst_loc.FS) * (ZF_CG.WL - inst_loc.WL)) +
           Wt_Baggage * ((ZF_CG.FS - baggage_loc.FS) * (ZF_CG.WL - baggage_loc.WL)))/32.174;

      An_Instance.The_Inertia.xx := Inertia.xx + moi_fuel.Xx - 156.7 * (1.0 - lg_pos)  +
           Wt_Zero_Fuel * ((cg_loc.BL - ZF_CG.BL)**2 + (cg_loc.WL - ZF_CG.WL)**2) / 32.174;

      An_Instance.The_Inertia.yy :=   Inertia.yy + moi_fuel.Yy - 113.2 * (1.0 - lg_pos) +
           Wt_Zero_Fuel * ((cg_loc.FS - ZF_CG.FS)**2 + (cg_loc.WL - ZF_CG.WL)**2) / 32.174;

      An_Instance.The_Inertia.zz :=   Inertia.zz + moi_fuel.Zz  - 114.2 * (1.0 - lg_pos) +
           Wt_Zero_Fuel * ((cg_loc.BL  - ZF_CG.BL)**2 + (cg_loc.FS - ZF_CG.FS)**2) / 32.174;

      An_Instance.The_Inertia.xz :=   Inertia.xz + moi_fuel.Xz - 16.2 * (1.0 - lg_pos) +
         Wt_Zero_Fuel * ((cg_loc.FS - ZF_CG.FS)* (cg_loc.WL - ZF_CG.WL) /32.174);

   end Set_Inertia;

   procedure Assign_Inertia (Moi            :in     Coordinate_Types.Inertia_Axis;
                             An_Instance    :in out Instance) is
   begin
      An_Instance.The_Inertia := MoI;
   end Assign_Inertia;

   function Get_Inertia(An_Instance :in Instance) return Coordinate_Types.Inertia_Axis is
   begin
      return An_Instance.The_Inertia;
   end Get_Inertia;

end Moment_of_Inertia;

