-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Temperature_Types;
with Lat_Long_Types;
with Length_Types;

package Location is

   type Instance is private;

   procedure Set_North(North_vel        :in     Length_Types.Feet_per_Sec;
                       Old_North_vel    :in     Length_Types.Feet_per_Sec;
                       Dt               :in     Float;
                       An_Instance      :in out Instance);

   procedure Set_Slew_North(Slew        :in     Length_Types.Feet_per_Sec;
                            An_Instance :in out Instance);

   procedure Assign_North (North        :in     Lat_Long_Types.Latitude_Degrees;
                           Old_North    :in     Lat_Long_Types.Latitude_Degrees;
                           An_Instance  :in out Instance);

   function Get_North(An_Instance :in Instance) return Lat_Long_Types.Latitude_Degrees;

   procedure Set_East(East_vel         :in     Length_Types.Feet_per_Sec;
                      Old_East_vel     :in     Length_Types.Feet_per_Sec;
                      Dt               :in     Float;
                      An_Instance      :in out Instance);

   procedure Set_Slew_East(Slew        :in     Length_Types.Feet_per_Sec;
                           An_Instance :in out Instance);

   procedure Assign_East (East         :in     Lat_Long_Types.Longitude_Degrees;
                          old_East     :in     Lat_Long_Types.Longitude_Degrees;
                          An_Instance  :in out Instance);

   function Get_East(An_Instance :in Instance) return Lat_Long_Types.Longitude_Degrees;

   procedure Set_Geometric_Altitude(z_Vel        :in     Length_Types.Feet_per_Sec;
                                    old_z_Vel    :in     Length_Types.Feet_per_Sec;
                                    Dt           :in     Float;
                                    An_Instance  :in out Instance);

   procedure Set_Slew_Geometric_Altitude(Slew        :in     Length_Types.Feet;
                                         An_Instance :in out Instance);

   procedure Assign_Geometric_Altitude (Altitude      :in     Length_Types.Feet;
                                        An_Instance   :in out Instance);

   function Get_Geometric_Altitude(An_Instance :in Instance) return Length_Types.Feet;

   function Get_Height_Above_Local_Terrain(An_Instance :in Instance) return Length_Types.Feet;

   procedure Set_Height_Above_Local_Terrain (Terrain_Height  :in     Length_Types.Feet;
                                             An_Instance     :in out Instance);

private
   type Instance is
      record
         The_North                           : Lat_Long_Types.Latitude_Degrees := 29.367450;
         The_East                            : Lat_Long_Types.Longitude_Degrees := -100.787897;
         The_Geometric_Altitude              : Length_Types.Feet := -1085.55;
         The_Height_Above_Local_Terrain      : Length_Types.Feet := -4.55;
         The_Last_Pass_North                 : Lat_Long_Types.Latitude_Degrees := 29.367450;
         The_Last_Pass_East                  : Lat_Long_Types.Longitude_Degrees :=-100.787897;
      end record;
end Location;


