-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
--with Ada.Numerics;

with Coordinate_Types;
with Length_Types;
with Simulation_Dictionary;

package JPATS_Simulated_Aircraft_Types is

-- The directory where DATA tables are stored.
    File_Path  : String := Simulation_Dictionary.Lookup ("Simulated_Aircraft_Dir");

    Maximum_Operating_Airspeed           : Length_Types.Knots := 320.0;
    The_Moment_of_Inertia_Basic          : Coordinate_Types.Inertia_Axis
                                               :=(2246.0,6444.0,8008.0,253.0);
    The_Reference_Coordinates_Basic      : Coordinate_Types.Reference_System
                                               :=(13.741,0.006,7.425);
    The_Reference_Coordinates_Student    : Coordinate_Types.Reference_System
                                               :=(13.566,0.0,8.233);
    The_Reference_Coordinates_Instructor : Coordinate_Types.Reference_System
                                               :=(18.241,0.0,8.766);
    The_Reference_Coordinates_Baggage    : Coordinate_Types.Reference_System
                                               :=(22.633_333,0.0,7.425);
    The_Normal_Height_On_Ground          : Length_Types.Feet := -4.25;

end JPATS_Simulated_Aircraft_Types;

