-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|

with Angle_Types;
with Coordinate_Types;
with Force_Types;
with Lat_Long_Types;
with Length_Types;
with Mass_Types;
with Normalized_Types;
with Temperature_Types;

package JPATS_Simulated_Aircraft is

    function Get_Acceleration_Body_Axis return Coordinate_Types.Cartesian;
    function load_factor return Coordinate_Types.Cartesian;
    function Get_Acceleration_Earth_Axis return Coordinate_Types.Cartesian;
    function Get_Angle_of_Attack return Angle_Types.Radians;
    function Get_Side_Slip_Angle return Angle_Types.Radians;
    function Get_Angle_of_Attack_Rate return Angle_Types.Radians_per_Sec;
    function Get_Zero_Fuel_Aircraft_Weight return Mass_Types.Lbm;
    function GW return Mass_Types.Lbm;
    function Get_Mass_of_Aircraft return Mass_Types.Slugs_per_Cubic_Feet;
    function Get_True_Airspeed return Length_Types.Feet_per_Sec;
    function Get_Mach_Number return Length_Types.Mach;
    function Get_Calibrated_Airspeed return Length_Types.Knots;
    function Get_Stall_Speed return Length_Types.Knots;
    function Get_Rate_of_Climb return Length_Types.Feet_per_Min;
    function Get_Ground_Speed return Length_Types.Feet_per_Sec;
    function Get_Angular_Acceleration_Body_Axis return Coordinate_Types.Attitude;
    function Get_Roll_Rate return Angle_Types.Radians_per_Sec;
    function Get_Pitch_Rate return Angle_Types.Radians_per_Sec;
    function Get_Yaw_Rate return Angle_Types.Radians_per_Sec;
    function Get_Roll_Angle return Angle_Types.Radians;
    function Get_Pitch_Angle return Angle_Types.Radians ;
    function Get_Hdg_Angle return Angle_Types.Radians;
    function direction return Angle_Types.Radians;
    function Get_Angular_Rate return Coordinate_Types.Attitude;
    function Get_Stall_Buffet return float;
    function Get_Crash_Sink_Rate return Boolean;
    function Get_Crash_Vertical_Load return Boolean;
    function Get_Crash_Excess_Airspeed return Boolean;
    function Get_Crash_Mountain_impact return Boolean ;
    function crashed return Boolean;
    function Get_Dynamic_Pressure return Force_Types.Pounds_per_Sq_Feet;
    function Get_Flight_Freeze return Boolean;
    function Get_Inertial_V_B return Coordinate_Types.Cartesian;
    function Get_North return Lat_Long_Types.Latitude_Degrees;
    function Get_East return Lat_Long_Types.Longitude_Degrees;
    function Get_Aircraft_Geometric_Altitude return Length_Types.Feet;
    function Get_Aircraft_Height_Above_Local_Terrain return Length_Types.Feet;
    function Get_Aircraft_Position return Lat_Long_Types.Position;
    function Get_Aircraft_Moment_of_Inertia return Coordinate_Types.Inertia_Axis;
    function Get_Nondimensional_Angular_Rate return Coordinate_Types.Attitude;
    function Rcr return Integer;
    function Get_L_1 return Float;
    function Get_L_2 return Float;
    function Get_L_3 return Float;
    function Get_M_1 return Float;
    function Get_M_2 return Float;
    function Get_M_3 return Float;
    function Get_N_1 return Float;
    function Get_N_2 return Float;
    function Get_N_3 return Float;
    function Get_Y_CG return Length_Types.Feet;
    function Get_X_CG return Length_Types.Feet;
    function Get_Z_CG return Length_Types.Feet;
    function Get_CG return Coordinate_Types.Reference_System;
    function Cg_PCT return Normalized_types.Normalize;
    function Get_V_B return Coordinate_Types.Cartesian;
    function Get_Vel_Ea return Coordinate_Types.Cartesian;
    function Float1 return Float;
    function Bool1 return Boolean;
    function Float2 return Float;
    function Bool2 return Boolean;
    function Float3 return Float;
    function Float4 return Float;
    function Float5 return Float;
    function Float6 return Float;
    function Float7 return Float;
    function Float8 return Float;
    function Float9 return Float;
    function Float10 return Float;
    function Reposition_In_Progress return Boolean;
    function slew_In_Progress return Boolean;
    function System_Reset return Boolean;
    function trim_Request return Boolean;
    function P_Dot return Float;

    procedure Set_System_Freeze;
    procedure Un_Freeze;

    -- debug ---
    procedure Set_Float2to9
      (Float2 : in     Float;
       Float3 : in     Float;
       Float4 : in     Float;
       Float5 : in     Float;
       Float6 : in     Float;
       Float7 : in     Float;
       Float8 : in     Float;
       Float9 : in     Float;
       Float10 : in     Float);


end JPATS_Simulated_Aircraft;
