-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Acceleration;
with Aerodynamic_Angle;
with Aircraft_Weight;
with Airspeed;
with Attitude_Angle;
with Location;
with Moment_of_Inertia;
with Reference_Coordinates;
with Quaternion;
with Velocity;
with JPATS_Simulated_Aircraft.Container;
with JPATS_Simulated_Aircraft_Types;
with JPATS_Simulated_Aircraft.IOS_Interface;
with JPATS_Simulated_Aircraft.Controller;

package body JPATS_Simulated_Aircraft is
   package Cnt renames Container;
   Ref_Coord : Reference_Coordinates.Instance renames
                           cnt.This_Subsystem.The_Reference_Coordinates;

function Get_Acceleration_Body_Axis return Coordinate_Types.Cartesian is
begin
    return Acceleration.Get_Body_Axis(Cnt.This_Subsystem.The_Acceleration);
end Get_Acceleration_Body_Axis;

function load_factor return Coordinate_Types.Cartesian is
begin
    return Acceleration.load_factor(Cnt.This_Subsystem.The_Acceleration);
end load_factor;

function direction return Angle_Types.Radians is
begin
   return Velocity.Direction(Cnt.This_Subsystem.The_velocity);
end Direction;

function Get_Acceleration_Earth_Axis return Coordinate_Types.Cartesian is
begin
    return Acceleration.Get_Earth_Axis(Cnt.This_Subsystem.The_Acceleration);
end Get_Acceleration_Earth_Axis;

function Get_Angle_of_Attack return Angle_Types.Radians is
begin
    return Aerodynamic_Angle.Get_Angle_of_Attack(Cnt.This_Subsystem.The_Aerodynamic_Angle);
end Get_Angle_of_Attack;

function Get_Side_Slip_Angle return Angle_Types.Radians is
begin
    return Aerodynamic_Angle.Get_Side_Slip_Angle(Cnt.This_Subsystem.The_Aerodynamic_Angle);
end Get_Side_Slip_Angle;

function Get_Angle_of_Attack_Rate return Angle_Types.Radians_per_Sec is
begin
    return Aerodynamic_Angle.Get_Angle_of_Attack_Rate(Cnt.This_Subsystem.The_Aerodynamic_Angle);
end Get_Angle_of_Attack_Rate;

function Get_Zero_Fuel_Aircraft_Weight return Temperature_Types.Rankine is
begin
    return Aircraft_Weight.Get_Zero_Fuel(Cnt.This_Subsystem.The_Aircraft_Weight);
end Get_Zero_Fuel_Aircraft_Weight;

function GW return Temperature_Types.Rankine is
begin
    return Aircraft_Weight.Get_GW(Cnt.This_Subsystem.The_Aircraft_Weight);
end GW;

function Get_Mass_of_Aircraft return Mass_Types.Slugs_per_Cubic_Feet is
begin
    return Aircraft_Weight.Get_Mass(Cnt.This_Subsystem.The_Aircraft_Weight);
end Get_Mass_of_Aircraft;

function Get_True_Airspeed return Length_Types.Feet_per_Sec is
begin
    return Airspeed.Get_True_Airspeed(Cnt.This_Subsystem.The_Airspeed);
end Get_True_Airspeed;

function Get_Mach_Number return Length_Types.Mach is
begin
    return Airspeed.Get_Mach_Number(Cnt.This_Subsystem.The_Airspeed);
end Get_Mach_Number;

function Get_Calibrated_Airspeed return Length_Types.Knots is
begin
    return Airspeed.Get_Calibrated_Airspeed(Cnt.This_Subsystem.The_Airspeed);
end Get_Calibrated_Airspeed;

function Get_Stall_Speed return Length_Types.Knots is
begin
    return Airspeed.Get_Stall_Speed(Cnt.This_Subsystem.The_Airspeed);
end Get_Stall_Speed;

function Get_Rate_of_Climb return Length_Types.Feet_per_Min is
begin
    return Airspeed.Get_Rate_of_Climb(Cnt.This_Subsystem.The_Airspeed);
end Get_Rate_of_Climb;

function Get_Ground_Speed return Length_Types.Feet_per_Sec is
begin
    return Airspeed.Get_Ground_Speed(Cnt.This_Subsystem.The_Airspeed);
end Get_Ground_Speed;

function Get_Angular_Acceleration_Body_Axis return Coordinate_Types.Attitude is  --rad/sec2
begin
    return Acceleration.Get_Angular(Cnt.This_Subsystem.The_Acceleration);
end Get_Angular_Acceleration_Body_Axis;

function Get_Roll_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Roll_Rate(Cnt.This_Subsystem.The_Velocity);
end Get_Roll_Rate;

function Get_Pitch_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Pitch_Rate(Cnt.This_Subsystem.The_Velocity);
end Get_Pitch_Rate;

function Get_Yaw_Rate return Angle_Types.Radians_per_Sec is
begin
    return Velocity.Get_Yaw_Rate(Cnt.This_Subsystem.The_Velocity);
end Get_Yaw_Rate;

function Get_Angular_Rate return Coordinate_Types.Attitude is
begin
    return (Velocity.Get_Roll_Rate(Cnt.This_Subsystem.The_Velocity),
            Velocity.Get_Pitch_Rate(Cnt.This_Subsystem.The_Velocity),
            Velocity.Get_Yaw_Rate(Cnt.This_Subsystem.The_Velocity));
end Get_Angular_Rate;

function Get_Roll_Angle return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Roll(Cnt.This_Subsystem.The_Attitude_Angle);
end Get_Roll_Angle;

function Get_Pitch_Angle return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Pitch(Cnt.This_Subsystem.The_Attitude_Angle);
end Get_Pitch_Angle;

function Get_Hdg_Angle return Angle_Types.Radians is
begin
    return Attitude_Angle.Get_Hdg(Cnt.This_Subsystem.The_Attitude_Angle);
end Get_Hdg_Angle;

function Get_Stall_Buffet return float is
begin
    return Cnt.This_Subsystem.Buffet_intens;
end Get_Stall_Buffet;

function Get_Crash_Sink_Rate return Boolean is
begin
       return  JPATS_Simulated_Aircraft.IOS_Interface.This_Ios_Interface.The_Sink_Rate_Crash;
end Get_Crash_Sink_Rate;

function Get_Crash_Vertical_Load return Boolean is
begin
      return JPATS_Simulated_Aircraft.IOS_Interface.This_Ios_Interface.The_Vertical_load_Crash;
end Get_Crash_Vertical_Load;

function Get_Crash_Excess_Airspeed return Boolean is
begin
   return JPATS_Simulated_Aircraft.IOS_Interface.This_Ios_Interface.The_Excess_airspeed_Crash;
end Get_Crash_Excess_Airspeed;

function Get_Crash_Mountain_Impact return Boolean is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.The_Terrain_impact_Crash;
end Get_Crash_Mountain_Impact;

function crashed return Boolean is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Crashed;
end crashed;

function Get_Flight_Freeze return Boolean is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.The_Flight_Freeze;
end Get_Flight_Freeze;

function Get_Inertial_V_B return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Inertial(Cnt.This_Subsystem.The_Velocity);
end Get_Inertial_V_B;

function Get_North return Lat_Long_Types.Latitude_Degrees is
begin
    return Location.Get_North(Cnt.This_Subsystem.The_Location);
end Get_North;

function Get_East return Lat_Long_Types.Longitude_Degrees is
begin
    return Location.Get_East(Cnt.This_Subsystem.The_Location);
end Get_East;

function Get_Aircraft_Geometric_Altitude return Length_Types.Feet is
begin  -- note simulation axis positive down, switch sign on output
    return -Location.Get_Geometric_Altitude(Cnt.This_Subsystem.The_Location);
end Get_Aircraft_Geometric_Altitude;

function Get_Aircraft_Height_Above_Local_Terrain return Length_Types.Feet is
begin
    return Location.Get_Height_Above_Local_Terrain(Cnt.This_Subsystem.The_Location);
end Get_Aircraft_Height_Above_Local_Terrain;

function Get_Aircraft_Position return Lat_Long_Types.Position is
begin
    return (Location.Get_North(Cnt.This_Subsystem.The_Location),
            Location.Get_East(Cnt.This_Subsystem.The_Location),
           - Location.Get_Geometric_Altitude(Cnt.This_Subsystem.The_Location));
end Get_Aircraft_Position;

function Get_Aircraft_Moment_of_Inertia return Coordinate_Types.Inertia_Axis is
begin
    return Moment_of_Inertia.Get_Inertia(Cnt.This_Subsystem.The_Moment_of_Inertia);
end Get_Aircraft_Moment_of_Inertia;

function Get_Nondimensional_Angular_Rate return Coordinate_Types.Attitude is
begin
    return Velocity.Get_Nondimensional_Angular(Cnt.This_Subsystem.The_Velocity);
end Get_Nondimensional_Angular_Rate;

function Get_L_1 return Float is
begin
    return Quaternion.Get_L_1(Cnt.This_Subsystem.The_Quaternion);
end Get_L_1;

function Get_L_2 return Float is
begin
    return Quaternion.Get_L_2(Cnt.This_Subsystem.The_Quaternion);
end Get_L_2;

function Get_L_3 return Float is
begin
    return Quaternion.Get_L_3(Cnt.This_Subsystem.The_Quaternion);
end Get_L_3;

function Get_M_1 return Float is
begin
    return Quaternion.Get_M_1(Cnt.This_Subsystem.The_Quaternion);
end Get_M_1;

function Get_M_2 return Float is
begin
    return Quaternion.Get_M_2(Cnt.This_Subsystem.The_Quaternion);
end Get_M_2;

function Get_M_3 return Float is
begin
    return Quaternion.Get_M_3(Cnt.This_Subsystem.The_Quaternion);
end Get_M_3;

function Get_N_1 return Float is
begin
    return Quaternion.Get_N_1(Cnt.This_Subsystem.The_Quaternion);
end Get_N_1;

function Get_N_2 return Float is
begin
    return Quaternion.Get_N_2(Cnt.This_Subsystem.The_Quaternion);
end Get_N_2;

function Get_N_3 return Float is
begin
    return Quaternion.Get_N_3(Cnt.This_Subsystem.The_Quaternion);
end Get_N_3;

function Get_Y_CG return Length_Types.Feet is
begin
    return Reference_Coordinates.Get_Y_CG(ref_coord);
end Get_Y_CG;

function Get_X_CG return Length_Types.Feet is
begin
    return Reference_Coordinates.Get_X_CG(ref_coord);
end Get_X_CG;

function Get_Z_CG return Length_Types.Feet is
begin
    return Reference_Coordinates.Get_Z_CG(ref_coord);
end Get_Z_CG;

function Get_CG return Coordinate_Types.Reference_System is
begin
    return (Reference_Coordinates.Get_X_CG(ref_coord),
            Reference_Coordinates.Get_Y_CG(ref_coord),
            Reference_Coordinates.Get_Z_CG(ref_coord));
end Get_CG;

function Cg_PCT return Normalized_types.normalize is
begin
    return Reference_Coordinates.CG_pct(ref_coord);
end Cg_pct;

function Rcr return Integer is
begin
   return  JPATS_Simulated_Aircraft.IOS_Interface.This_Ios_Interface.runway_Condition;
end Rcr;

function Get_V_B return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Body_Axis(Cnt.This_Subsystem.The_Velocity);
end Get_V_B;

function Get_Vel_Ea return Coordinate_Types.Cartesian is
begin
    return Velocity.Get_Earth_Axis(Cnt.This_Subsystem.The_Velocity);
end Get_Vel_Ea;

function Get_Dynamic_Pressure return Force_Types.Pounds_per_Sq_Feet is
begin
    return airspeed.dynamic_pressure(Cnt.This_Subsystem.The_airspeed);
end Get_Dynamic_Pressure;

function float1 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float1;
end float1;

function float2 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float2;
end float2;

function float3 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float3;
end float3;

function float4 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float4;
end float4;

function float5 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float5;
end float5;

function float6 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float6;
end float6;

function float7 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float7;
end float7;

function float8 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float8;
end float8;

function float9 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float9;
end float9;

function float10 return float is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.float10;
end float10;

function bool1 return boolean is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.bool1;
end bool1;

function bool2 return boolean is
begin
    return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.bool2;
end bool2;

function Reposition_In_Progress return boolean is
begin
    return false;
end Reposition_In_Progress;

function slew_In_Progress return boolean is
begin
    return Cnt.This_Subsystem.slew_In_Progress;
end slew_In_Progress;

function System_Reset return Boolean is
begin
   return Cnt.This_Subsystem.System_Reset_Flag;
end System_Reset;

function Trim_Request return Boolean is
begin
   return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.trim_request;
end trim_request;

function P_Dot return Float is
begin
   return Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.P_Dot;
end P_Dot;

procedure Set_System_Freeze is
begin
   Controller.Misc_Freeze_Request := True;
end Set_System_Freeze;

procedure Un_Freeze is
begin
   Controller.Un_Freeze;
end Un_Freeze;

procedure Set_Float2to9
      (Float2 : in     Float;
       Float3 : in     Float;
       Float4 : in     Float;
       Float5 : in     Float;
       Float6 : in     Float;
       Float7 : in     Float;
       Float8 : in     Float;
       Float9 : in     Float;
       Float10 : in     Float) is
begin
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float2  := Float2;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float3  := Float3;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float4  := Float4;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float5  := Float5;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float6  := Float6;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float7  := Float7;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float8  := Float8;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float9  := Float9;
   Jpats_Simulated_Aircraft.Ios_Interface.This_Ios_Interface.Float10 := Float10;

end Set_Float2to9;

end JPATS_Simulated_Aircraft;

