-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--| Reference: Kimball, D., "Flight Simulation Mathematical Model of
--|            the Beech MkII Joint Primary Aircraft Training System
--|            (JPATS)", Document 133E794 Rev. B, 11 November, 1998.
--|            Flight Manual Dated April 30,1998.
--|                          AIR FORCE TO 1T-6A-1,
--|                          NAVY (NAVAIR) A1-T6AAA-NFM-100
--|            Standards from Flight Dynamics Group
--|            Flight Safety International, Inc., System Simulation Division
--|            Broken Arrow, OK 74012
-------------------------------------------------------------------------------
--|

with JPATS_Aircraft_Body;
with JPATS_Auto_Test;
with JPATS_Fuel;
with JPATS_Landing_Gear;
with JPATS_Landing_Gear_Types;
with JPATS_Simulated_Aircraft_Types;
with JPATS_Simulated_Aircraft.Container;
with JPATS_Simulated_Aircraft.IOS_Interface;

with Aircraft_Weight;
with Reference_Coordinates;
with Moment_of_Inertia;
with Save_Restore;

package body JPATS_Simulated_Aircraft.Mass_Property_Controller is
   Crew                : Integer := 2;
   Fuel_cg             : Coordinate_Types.Reference_System := (100.0,0.0,100.0);
   Temp                : Float  := 6000.0;
   GW                  : Mass_Types.Lbm := 5200.0;
   Start_Cg            : Coordinate_Types.Reference_System := (100.0,0.0,100.0);
   Start_Pos           : Float := 1.0;
   procedure Initialize is
   begin
      null;
   end Initialize;

procedure Update (dt:in Float) is

    Basic_Inertia                       : Coordinate_Types.Inertia_Axis;
    Fuel_Inertia                        : Coordinate_Types.Inertia_Axis;
    Weight_Zero_Fuel                    : Mass_Types.Lbm ;
    Weight_Basic                        : Mass_Types.Lbm := 4824.0;
    Weight_Student                      : Mass_Types.Lbm := 170.0;
    Weight_Instructor                   : Mass_Types.Lbm := 170.0;
    Weight_Baggage                      : Mass_Types.Lbm := 20.0;
    Weight_Fuel                         : Mass_Types.Lbm;
    Weight_Ice                          : Mass_Types.Lbm := 0.0;
    Current_CG                          : Coordinate_Types.Reference_System;
    D_X_Cg                              : Float := 0.0;
    D_z_Cg                              : Float := 0.0;
    Zero_Fuel_Cg                        : Coordinate_Types.Reference_System;
    Gear_Pos                            : Normalized_Types.Normalize;
    Basic                               : Coordinate_Types.Reference_System;
    Baggage                             : Coordinate_Types.Reference_System;
    Student                             : Coordinate_Types.Reference_System;
    Instructor                          : Coordinate_Types.Reference_System;
begin
   Gear_Pos := JPATS_Landing_Gear.Mean_Gear_Position;
   if JPATS_Auto_Test.At_Phase > 0 and JPATS_Auto_Test.At_Phase /= 9
       and JPATS_Auto_Test.At_Phase /= 5 and  JPATS_Auto_Test.Test_Number /= 921 and
          JPATS_Auto_Test.Test_Number /= 922 then
      -- set autotest weight, inertia and cg

         if JPATS_Auto_Test.At_Phase < 4 then
            Start_Pos := Gear_Pos;
            start_CG := JPATS_Auto_Test.Cg;
         end if;
         temp :=  JPATS_Auto_Test.Gw;       -- note: ballast used during flight test
         Aircraft_Weight.Assign_Gw          -- to obtain extreme weight and cg
           (temp,Container.This_Subsystem.The_Aircraft_Weight);

         D_X_Cg := 3068.0 * (Start_Pos - Gear_Pos)/Temp;
         D_Z_Cg := 6307.0 * (Start_Pos - Gear_Pos)/Temp;
         Current_Cg.Fs := Start_Cg.Fs + D_X_Cg;
         Current_Cg.Wl := Start_Cg.Wl + D_Z_Cg;
         current_cg.bl := start_cg.bl;
         Reference_Coordinates.Assign_Y_CG
              (Current_CG.Bl/12.0,
               An_Instance => Container.This_Subsystem.The_Reference_Coordinates);
         Reference_Coordinates.Assign_X_CG
              (Current_CG.Fs/12.0,
               An_Instance => Container.This_Subsystem.The_Reference_Coordinates);
         Reference_Coordinates.Assign_Z_CG
              (Current_CG.Wl/12.0,
               An_Instance => Container.This_Subsystem.The_Reference_Coordinates);
         Moment_of_Inertia.Assign_Inertia (JPATS_Auto_Test.Inertia,
                            An_Instance => Container.This_Subsystem.The_Moment_of_Inertia);
   else
      if  JPATS_Auto_Test.Test_Number = 921 or
              JPATS_Auto_Test.Test_Number = 922 then
         Crew := JPATS_Auto_test.Num_Pil;
         Weight_Baggage := 0.0;
      else
         Crew := JPATS_Simulated_Aircraft.IOS_Interface.This_Ios_Interface.Number_Pilots;
         if crew < 1 then
             crew := 1;
         end if;
      end if;
      if not (Save_Restore.Replay_Trimming or Save_Restore.Replay_In_Progress) then
         Container.This_Subsystem.Number_Of_Pilots := Crew;
      end if;

      Weight_Instructor             := 170.0 * Float(Container.This_Subsystem.Number_Of_Pilots - 1);
      Weight_Fuel                   := JPATS_Fuel.Get_Fuel_Tank_Weight; -- - 40.0;
      if Weight_Fuel < 1.0 then
         Weight_Fuel := 1.0;
      end if;

      Fuel_CG                       := JPATS_Fuel.Get_Current_Center_Of_gravity;
      Weight_Ice := JPATS_Aircraft_Body.Get_Wing_Body_Plus_Weight_Ice;
      Aircraft_Weight.Set_Zero_Fuel (Weight_Basic,
                                     Weight_Student,
                                     Weight_Instructor,
                                     Weight_Baggage,
                                     Container.This_Subsystem.The_Aircraft_Weight);

      Aircraft_Weight.Set_GW(Weight_Fuel,
                          Weight_Ice,
                          Container.This_Subsystem.The_Aircraft_Weight);-- also sets mass

      Basic              := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Basic;
      Baggage            := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Baggage;
      Student            := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Student;
      Instructor         := JPATS_Simulated_Aircraft_Types.The_Reference_Coordinates_Instructor;
      Weight_Zero_Fuel   := Aircraft_Weight.Get_Zero_Fuel(Container.This_Subsystem.The_Aircraft_Weight);
      GW                 := Aircraft_Weight.Get_GW(Container.This_Subsystem.The_Aircraft_Weight);

      Reference_Coordinates.Set_Zero_Fuel  -- zero fuel cg
       (Basic             ,
        Baggage           ,
        Student           ,
        Instructor        ,
        Weight_Zero_Fuel  ,
        Weight_Basic      ,
        Weight_Student    ,
        Weight_Instructor ,
        Weight_Baggage    ,
        An_Instance => Container.This_Subsystem.The_Reference_Coordinates);

        Reference_Coordinates.Set_Y_Cg  -- loaded CG
           (Weight_Zero_Fuel   ,
            GW                 ,
            Fuel_Cg.bl         ,
            An_Instance => Container.This_Subsystem.The_Reference_Coordinates);

        Gear_Pos := JPATS_Landing_Gear.Mean_Gear_Position;
        Reference_Coordinates.Set_X_Cg  -- loaded CG
            (Weight_Zero_Fuel  ,
             GW                ,
             Fuel_cg.Fs        ,
             Gear_Pos          ,
             An_Instance => Container.This_Subsystem.The_Reference_Coordinates);

        Reference_Coordinates.Set_Z_Cg  -- loaded CG
            (Weight_Zero_Fuel  ,
             GW                ,
             Fuel_cg.Wl        ,
             Gear_Pos          ,
             An_Instance => Container.This_Subsystem.The_Reference_Coordinates);

        Basic_Inertia  := JPATS_Simulated_Aircraft_Types.The_Moment_of_Inertia_Basic;
        Fuel_Inertia   := JPATS_Fuel.Get_Moment_of_Inertia;

        Current_CG := (Reference_Coordinates.Get_X_Cg
              (An_Instance => Container.This_Subsystem.The_Reference_Coordinates),
                       Reference_Coordinates.Get_Y_Cg
              (An_Instance => Container.This_Subsystem.The_Reference_Coordinates),
                       Reference_Coordinates.Get_Z_Cg
              (An_Instance => Container.This_Subsystem.The_Reference_Coordinates));
        Zero_Fuel_CG  := Reference_Coordinates.Get_Zero_Fuel
                  (An_Instance => Container.This_Subsystem.The_Reference_Coordinates);

        Moment_of_Inertia.Set_Inertia
          (Basic_Inertia    ,
           Fuel_Inertia     ,
           Weight_Zero_Fuel ,
           Weight_Basic     ,
           Weight_Student   ,
           Weight_Instructor,
           Weight_Baggage   ,
           Basic            ,
           Student          ,
           Instructor       ,
           Baggage          ,
           Current_Cg       ,
           Zero_Fuel_cg     ,
           Gear_Pos         ,
           An_Instance => Container.This_Subsystem.The_Moment_of_Inertia);
   end if; -- end if autotest
   Reference_Coordinates.Compute_Cg_Pct_Mac
                  (An_Instance => Container.This_Subsystem.The_Reference_Coordinates);
 -- IOS displays
   jpats_simulated_aircraft.ios_interface.This_Ios_Interface.Cg_Loc_Fs := Current_Cg.fs * 12.0;
   jpats_simulated_aircraft.ios_interface.This_Ios_Interface.Cg_Loc_pct := Jpats_Simulated_Aircraft.Cg_pct;
   jpats_simulated_aircraft.ios_interface.This_Ios_Interface.Gross_Weight := Gw;
   jpats_simulated_aircraft.ios_interface.this_ios_Interface.ice_Weight :=  Weight_Ice;
end Update;

end JPATS_Simulated_Aircraft.Mass_Property_Controller;




