-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with JPATS_IOS_Interface;

package JPATS_Simulated_Aircraft.IOS_Interface is

  type Instance is
     record
       The_Altitude_Freeze             : Boolean:= False;
       The_Flight_Freeze               : Boolean:= True;
       The_Position_Freeze             : Boolean:= False;
       The_Heading_Freeze              : Boolean:= False;
       Use_Variable_Slew_rate          : Boolean := False;
       Variable_Slew_Rate              : Integer := 0;
       Slew_Heading_Rate               : Float := 3.0;
       Slew_Vertical_Rate              : Float := 3600.0;
       Slew_Position_Rate              : Float := 648.0;
       Slew_Rate                       : Integer:= 1;
       Slew_Up                         : Boolean := False;
       Slew_Down                       : Boolean := False;
       Command_Heading                 : Float := 0.0;
       Command_Altitude                : Float := 0.0;
       Turn_Left                       : Boolean := False;
       Turn_Right                      : Boolean := False;
       Slew_North                      : Boolean := False;
       Slew_South                      : Boolean := False;
       Slew_East                       : Boolean := False;
       Slew_West                       : Boolean := False;
       Slew_Fwd                        : Boolean := False;
       Slew_Aft                        : Boolean := False;
       Slew_Left                       : Boolean := False;
       Slew_Right                      : Boolean := False;
       Latitude                        : Long_Float;
       Longitude                       : Long_Float;
       Pitch_Angle                     : Angle_Types.Radians;
       Bank_Angle                      : Angle_Types.Radians;
       Pitch_Rate                      : Float := 0.0;
       Roll_Rate                       : Float := 0.0;
       Number_Pilots                   : Integer := 1;
       The_Sink_Rate_Crash             : Boolean := False;
       The_Vertical_Load_Crash         : Boolean := False;
       The_Excess_Airspeed_Crash       : Boolean := False;
       The_Terrain_Impact_Crash        : Boolean := False;
       Crashed                         : Boolean := False;
       Jacks                           : Boolean := False;
       Gross_Weight                    : Float := 6000.0;
       Cg_Loc_FS                       : Float := 180.0;
       Cg_Loc_Pct                      : Float := 25.0;
       Geometric_Altitude              : Float := 0.0;
       Mag_Hdg                         : Float := 0.0;
       Height_Above_Ground             : Float := 0.0;
       Runway_Condition                : Integer := 23;
       Ice_Weight                      : Float := 0.0;
       System_Reset                    : Boolean := False;
       Chocks                          : Boolean := False;
       Slewing                         : Integer := 0;
       Trim_Request                    : Boolean := False;
       -- debug variables
       Cas                          : Float;
       Elev                         : Float;
       L_Gear                       : Float;
       Nwa                          : Float;
       Aoa                          : Float;
       Rud                          : Float;
       R_Gear                       : Float;
       E_Tab                        : Float;
       Beta                         : Float;
       L_Ail                        : Float;
       N_Gear                       : Float;
       R_Tab                        : Float;
       Q_Dyn                        : Float;
       R_Ail                        : Float;
       Sb                           : Float;
       A_Tab                        : Float;
       Flap                         : Float;
       Fx_Tot                       : Float;
       Fy_Tot                       : Float;
       Fz_Tot                       : Float;
       Fx_Aero                      : Float;
       Fy_Aero                      : Float;
       Fz_Aero                      : Float;
       Fx_Gnd                       : Float;
       Fy_Gnd                       : Float;
       Fz_Gnd                       : Float;
       Fx_Eng                       : Float;
       Fy_Eng                       : Float;
       Fz_Eng                       : Float;
       Mx_Tot                       : Float;
       My_Tot                       : Float;
       Mz_Tot                       : Float;
       Mx_Aero                      : Float;
       My_Aero                      : Float;
       Mz_Aero                      : Float;
       Mx_Gnd                       : Float;
       My_Gnd                       : Float;
       Mz_Gnd                       : Float;
       Mx_Eng                       : Float;
       My_Eng                       : Float;
       Mz_Eng                       : Float;
       Ax                           : Float;
       Ay                           : Float;
       Az                           : Float;
       P_Dot                        : Float;
       P                            : Float;
       Q_Dot                        : Float;
       Q                            : Float;
       R_Dot                        : Float;
       R                            : Float;
       Vx                           : Float;
       Vy                           : Float;
       Vz                           : Float;
       L_Brake_Pos                  : Float;
       L_Brake_F                    : Float;
       R_Brake_Pos                  : Float;
       R_Brake_F                    : Float;
       Long_Stk_Pos                 : Float;
       Long_Stk_F                   : Float;
       Lat_Stk_Pos                  : Float;
       Lat_Stk_F                    : Float;
       Pedal_Pos                    : Float;
       Pedal_F                      : Float;
       Avg_Ail                      : Float;
       Ias                          : Float;
       Mach                         : Float;
       Oat                          : Float;
       Density                      : Float;
       Pla                          : Float;
       Float1                       : Float := 0.85;
       Float2                       : Float := 0.94;
       Float3                       : Float := -1.0;
       Float4                       : Float := 0.0;
       Float5                       : Float := 0.0;
       Float6                       : Float := 0.0;
       Float7                       : Float := 0.0;
       Float8                       : Float := 0.0;
       Float9                       : Float := 0.0;
       Float10                      : Float := 0.0;
       Bool1                        : Boolean := False;
       Bool2                        : Boolean := False;
     end record;

  This_IOS_Interface : Instance;

  procedure Register_Ios_Variables;

end JPATS_Simulated_Aircraft.IOS_Interface;

