-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with JPATS_IOS_Interface;

package body JPATS_Simulated_Aircraft.IOS_Interface is

  procedure Alt_Freeze (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.The_Altitude_Freeze := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Alt_Freeze;

  procedure Flt_Freeze (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.The_Flight_Freeze := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Flt_Freeze;

  procedure Pos_Freeze (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.The_Position_Freeze := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Pos_Freeze;

  procedure Hdg_Freeze (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.The_Heading_Freeze := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Hdg_Freeze;

  procedure Slew_Up (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Up := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_Up then
      This_Ios_Interface.Slew_Down := False;
    end if;
  end Slew_Up;

  procedure Slew_Down (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Down := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_Down then
      This_Ios_Interface.Slew_Up := False;
    end if;
  end Slew_Down;

  procedure Use_Variable_Slew_Rate (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Use_Variable_Slew_Rate := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Use_Variable_Slew_Rate then
       This_Ios_Interface.Slew_Vertical_Rate := Float(This_Ios_Interface.Variable_Slew_Rate) * 250.0; -- 0 to 90000 ft per minute
       This_Ios_Interface.Slew_Heading_Rate := Float(This_Ios_Interface.Variable_Slew_Rate) * 0.0555555555; -- 0 to 20 deg per sec
       This_Ios_Interface.Slew_Position_Rate := Float(This_Ios_Interface.Variable_Slew_Rate) * 0.868976; -- convert 0 to 360 mph to kts
    else
       if This_Ios_Interface.Slew_Rate = 3 then
           This_Ios_Interface.Slew_Vertical_Rate := 90000.0;  -- ft/min
           This_Ios_Interface.Slew_Heading_Rate := 20.0;      -- deg/sec
           This_Ios_Interface.Slew_Position_Rate := 21619.86; -- kts
        elsif  This_Ios_Interface.Slew_Rate = 2 then
           This_Ios_Interface.Slew_Vertical_Rate := 18000.0;
           This_Ios_Interface.Slew_Heading_Rate := 10.0;
           This_Ios_Interface.Slew_Position_Rate := 2160.0;
        else
           This_Ios_Interface.Slew_Vertical_Rate := 3600.0;
           This_Ios_Interface.Slew_Heading_Rate := 3.0;
           This_Ios_Interface.Slew_Position_Rate := 648.0;
        end if;
    end if;
  end Use_Variable_Slew_Rate;

  procedure Variable_Slew_Rate (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Variable_Slew_Rate := JPATS_IOS_Interface.Convert_To_Integer(PData);
    if This_Ios_Interface.Use_Variable_Slew_Rate then
       This_Ios_Interface.Slew_Vertical_Rate := Float(This_Ios_Interface.Variable_Slew_Rate) * 250.0; -- 0 to 90000 ft per minute
       This_Ios_Interface.Slew_Heading_Rate := Float(This_Ios_Interface.Variable_Slew_Rate) * 0.0555555555; -- 0 to 20 deg per sec
       This_Ios_Interface.Slew_Position_Rate := Float(This_Ios_Interface.Variable_Slew_Rate) * 0.868976; -- convert 0 to 360 mph to kts
    end if;
  end Variable_Slew_Rate;

  procedure Slew_Heading_Rate (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Heading_Rate := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Slew_Heading_Rate;

  procedure Slew_Vertical_Rate (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Vertical_Rate := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Slew_Vertical_Rate;

  procedure Slew_Position_Rate (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Position_Rate := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Slew_Position_Rate;

  procedure Slew_Rate (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Rate := JPATS_IOS_Interface.Convert_To_Integer(PData);
     if not This_Ios_Interface.Use_Variable_Slew_Rate then
        if This_Ios_Interface.Slew_Rate = 3 then
           This_Ios_Interface.Slew_Vertical_Rate := 90000.0;  -- ft/min
           This_Ios_Interface.Slew_Heading_Rate := 20.0;      -- deg/sec
           This_Ios_Interface.Slew_Position_Rate := 21619.86; -- kts
        elsif  This_Ios_Interface.Slew_Rate = 2 then
           This_Ios_Interface.Slew_Vertical_Rate := 18000.0;
           This_Ios_Interface.Slew_Heading_Rate := 10.0;
           This_Ios_Interface.Slew_Position_Rate := 2160.0;
        else
           This_Ios_Interface.Slew_Vertical_Rate := 3600.0;
           This_Ios_Interface.Slew_Heading_Rate := 3.0;
           This_Ios_Interface.Slew_Position_Rate := 648.0;
        end if;
     end if;
  end Slew_Rate;

  procedure Cmd_Hdg (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Command_Heading := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Cmd_Hdg;

  procedure Cmd_Alt (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Command_Altitude := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Cmd_Alt;

  procedure Turn_Left (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Turn_Left := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Turn_Left then
      This_Ios_Interface.Turn_Right := False;
    end if;
  end Turn_Left;

  procedure Turn_Right (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Turn_Right := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Turn_Right then
      This_Ios_Interface.Turn_Left := False;
    end if;
  end Turn_Right;

  procedure Slew_East (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_East := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_East then
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Left  := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_East;

  procedure Slew_West (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_West := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_West then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Left  := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_West;

  procedure Slew_North (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_North := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_North then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Left  := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_North;

  procedure Slew_South (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_South := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_South then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Left  := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_South;

  procedure Slew_Fwd (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Fwd := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_Fwd then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Left  := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_Fwd;

  procedure Slew_Aft (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Aft := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_Aft then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Left  := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_Aft;

  procedure Slew_Left (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Left := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_Left then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Right := False;
    end if;
  end Slew_Left;

  procedure Slew_Right (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Slew_Right := JPATS_IOS_Interface.Convert_To_Bool(PData);
    if This_Ios_Interface.Slew_Right then
      This_Ios_Interface.Slew_East  := False;
      This_Ios_Interface.Slew_West  := False;
      This_Ios_Interface.Slew_North := False;
      This_Ios_Interface.Slew_South := False;
      This_Ios_Interface.Slew_Fwd   := False;
      This_Ios_Interface.Slew_Aft   := False;
      This_Ios_Interface.Slew_Left  := False;
    end if;
  end Slew_Right;


  procedure Numpil (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Number_Pilots := JPATS_IOS_Interface.Convert_To_Integer(PData);
  end Numpil;

  procedure Jacks (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Jacks := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Jacks;

  procedure Float_1 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float1 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_1;

  procedure Float_2 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float2 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_2;

  procedure Float_3 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float3 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_3;

  procedure Float_4 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float4 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_4;

  procedure Float_5 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float5 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_5;

  procedure Float_6 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float6 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_6;

  procedure Float_7 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float7 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_7;

  procedure Float_8 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float8 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_8;

  procedure Float_9 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float9 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_9;

  procedure Float_10 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Float10 := JPATS_IOS_Interface.Convert_To_Float(PData);
  end Float_10;

  procedure Bool_2 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Bool2 := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Bool_2;

  procedure Bool_1 (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Bool1 := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end Bool_1;

  procedure Runway_Condition (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.Runway_Condition := JPATS_IOS_Interface.Convert_To_Integer(Pdata);
  end Runway_Condition;

  procedure System_Reset (PData : JPATS_IOS_Interface.Set_Value) is
  begin
    This_Ios_Interface.System_Reset := JPATS_IOS_Interface.Convert_To_Bool(PData);
  end System_Reset;

  procedure Register_Ios_Variables is

  begin

    JPATS_IOS_Interface.Register
      ( Name        => "Turn Left",
        Variable    => This_Ios_Interface.Turn_Left'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Turn_Left'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Turn Right",
        Variable    => This_Ios_Interface.Turn_Right'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Turn_Right'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew Up",
        Variable    => This_Ios_Interface.Slew_Up'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Up'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew Down",
        Variable    => This_Ios_Interface.Slew_Down'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Down'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew Left",
        Variable    => This_Ios_Interface.Slew_Left'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Left'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew Right",
        Variable    => This_Ios_Interface.Slew_Right'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Right'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew Forward",
        Variable    => This_Ios_Interface.Slew_Fwd'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Fwd'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew back",
        Variable    => This_Ios_Interface.Slew_Aft'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Aft'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew North",
        Variable    => This_Ios_Interface.Slew_North'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_North'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew south",
        Variable    => This_Ios_Interface.Slew_South'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_South'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew East",
        Variable    => This_Ios_Interface.Slew_East'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_East'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew west",
        Variable    => This_Ios_Interface.Slew_West'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_West'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "command heading",
        Variable    => This_Ios_Interface.Command_Heading'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Cmd_Hdg'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Command Altitude",
        Variable    => This_Ios_Interface.Command_Altitude'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Cmd_Alt'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Runway_condition",
        Variable    => This_Ios_Interface.Runway_Condition'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Runway_Condition'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slew_Speed",
        Variable    => This_Ios_Interface. Slew_Rate'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Rate'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "variable_slew_speed",
        Variable    => This_Ios_Interface.Variable_Slew_Rate'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Variable_Slew_Rate'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "use_variable_slew_speed",
        Variable    => This_Ios_Interface.Use_Variable_Slew_Rate'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Use_Variable_Slew_Rate'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "slew_heading_rate",
        Variable    => This_Ios_Interface.Slew_Heading_Rate'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Heading_Rate'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "slew_vertical_rate",
        Variable    => This_Ios_Interface.Slew_Vertical_Rate'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Vertical_Rate'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "slew_position_rate",
        Variable    => This_Ios_Interface.Slew_Position_Rate'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Slew_Position_Rate'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Sink Rate",
        Variable    => This_Ios_Interface.The_Sink_Rate_Crash'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Over G",
        Variable    => This_Ios_Interface.The_Vertical_Load_Crash'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Over Speed",
        Variable    => This_Ios_Interface.The_Excess_Airspeed_Crash'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Terrain",
        Variable    => This_Ios_Interface.The_Terrain_Impact_Crash'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "crashed",
        Variable    => This_Ios_Interface.Crashed'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "on jacks",
        Variable    => This_Ios_Interface. Jacks'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Jacks'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "position freeze",
        Variable    => This_Ios_Interface.The_Position_Freeze'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Pos_Freeze'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "flight freeze",
        Variable    => This_Ios_Interface.The_Flight_Freeze'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Flt_Freeze'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "altitude freeze",
        Variable    => This_Ios_Interface.The_Altitude_Freeze'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Alt_Freeze'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "heading freeze",
        Variable    => This_Ios_Interface.The_Heading_Freeze'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Hdg_Freeze'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Number Pilots",
        Variable    => This_Ios_Interface.Number_Pilots'Address,
        Set_Routine => JPATS_Simulated_Aircraft.IOS_Interface.Numpil'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "latitude",
        Variable    => This_Ios_Interface.Latitude'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "longitude",
        Variable    => This_Ios_Interface.Longitude'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "gross weight",
        Variable    => This_Ios_Interface.Gross_Weight'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "CG loc fs",
        Variable    => This_Ios_Interface.CG_Loc_Fs'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "CG loc pct",
        Variable    => This_Ios_Interface.CG_Loc_Pct'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "altitude",
        Variable    => This_Ios_Interface.Geometric_Altitude'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mag_Hdg",
        Variable    => This_Ios_Interface.Mag_Hdg'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "height_above_ground",
        Variable    => This_Ios_Interface.Height_Above_Ground'Address
        );

    --debug variables

    JPATS_IOS_Interface.Register
      ( Name        => "Cas",
        Variable    => This_Ios_Interface.Cas'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Elev",
        Variable    => This_Ios_Interface.Elev'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Rud",
        Variable    => This_Ios_Interface.Rud'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "L_Ail",
        Variable    => This_Ios_Interface.L_Ail'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "R_Ail",
        Variable    => This_Ios_Interface.R_Ail'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "Nwa",
        Variable    => This_Ios_Interface.Nwa'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "L_Gear",
        Variable    => This_Ios_Interface.L_Gear'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "R_Gear",
        Variable    => This_Ios_Interface.R_Gear'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "N_Gear",
        Variable    => This_Ios_Interface.N_Gear'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Aoa",
        Variable    => This_Ios_Interface.Aoa'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Beta",
        Variable    => This_Ios_Interface.Beta'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Flap",
        Variable    => This_Ios_Interface.Flap'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Sb",
        Variable    => This_Ios_Interface.Sb'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "E_Tab",
        Variable    => This_Ios_Interface.E_Tab'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "R_Tab",
        Variable    => This_Ios_Interface.R_Tab'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "A_Tab",
        Variable    => This_Ios_Interface.A_Tab'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Ax",
        Variable    => This_Ios_Interface.Ax'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Ay",
        Variable    => This_Ios_Interface.Ay'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Az",
        Variable    => This_Ios_Interface.Az'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Vx",
        Variable    => This_Ios_Interface.Vx'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Vy",
        Variable    => This_Ios_Interface.Vy'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Vz",
        Variable    => This_Ios_Interface.Vz'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "P_Dot",
        Variable    => This_Ios_Interface.P_Dot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "P",
        Variable    => This_Ios_Interface.P'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Q_Dot",
        Variable    => This_Ios_Interface.Q_Dot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Q",
        Variable    => This_Ios_Interface.Q'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "R_Dot",
        Variable    => This_Ios_Interface.R_Dot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "R",
        Variable    => This_Ios_Interface.R'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Q_Dyn",
        Variable    => This_Ios_Interface.Q_Dyn'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fx_Eng",
        Variable    => This_Ios_Interface.Fx_Eng'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fy_Eng",
        Variable    => This_Ios_Interface.Fy_Eng'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fz_Eng",
        Variable    => This_Ios_Interface.Fz_Eng'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mx_Eng",
        Variable    => This_Ios_Interface.Mx_Eng'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "My_Eng",
        Variable    => This_Ios_Interface.My_Eng'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mz_Eng",
        Variable    => This_Ios_Interface.Mz_Eng'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fx_Tot",
        Variable    => This_Ios_Interface.Fx_Tot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fy_Tot",
        Variable    => This_Ios_Interface.Fy_Tot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fz_Tot",
        Variable    => This_Ios_Interface.Fz_Tot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mx_Tot",
        Variable    => This_Ios_Interface.Mx_Tot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "My_Tot",
        Variable    => This_Ios_Interface.My_Tot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mz_Tot",
        Variable    => This_Ios_Interface.Mz_Tot'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fx_Aero",
        Variable    => This_Ios_Interface.Fx_Aero'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fy_Aero",
        Variable    => This_Ios_Interface.Fy_Aero'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fz_Aero",
        Variable    => This_Ios_Interface.Fz_Aero'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mx_Aero",
        Variable    => This_Ios_Interface.Mx_Aero'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "My_Aero",
        Variable    => This_Ios_Interface.My_Aero'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mz_Aero",
        Variable    => This_Ios_Interface.Mz_Aero'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fx_Gnd",
        Variable    => This_Ios_Interface.Fx_Gnd'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fy_Gnd",
        Variable    => This_Ios_Interface.Fy_Gnd'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Fz_Gnd",
        Variable    => This_Ios_Interface.Fz_Gnd'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mx_Gnd",
        Variable    => This_Ios_Interface.Mx_Gnd'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "My_Gnd",
        Variable    => This_Ios_Interface.My_Gnd'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Mz_Gnd",
        Variable    => This_Ios_Interface.Mz_Gnd'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Ice_weight",
        Variable    => This_Ios_Interface.Ice_Weight'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_1",
        Variable    => This_Ios_Interface.Float1'Address,
        Set_Routine => Float_1'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_2",
        Variable    => This_Ios_Interface.Float2'Address,
        Set_Routine => Float_2'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_3",
        Variable    => This_Ios_Interface.Float3'Address,
        Set_Routine => Float_3'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_4",
        Variable    => This_Ios_Interface.Float4'Address,
        Set_Routine => Float_4'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_5",
        Variable    => This_Ios_Interface.Float5'Address,
        Set_Routine => Float_5'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_6",
        Variable    => This_Ios_Interface.Float6'Address,
        Set_Routine => Float_6'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_7",
        Variable    => This_Ios_Interface.Float7'Address,
        Set_Routine => Float_7'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_8",
        Variable    => This_Ios_Interface.Float8'Address,
        Set_Routine => Float_8'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_9",
        Variable    => This_Ios_Interface.Float9'Address,
        Set_Routine => Float_9'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "float_10",
        Variable    => This_Ios_Interface.Float10'Address,
        Set_Routine => Float_10'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "bool_1",
        Variable    => This_Ios_Interface.Bool1'Address,
        Set_Routine => Bool_1'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "bool_2",
        Variable    => This_Ios_Interface.Bool2'Address,
        Set_Routine => Bool_2'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "System Reset",
        Variable    => This_Ios_Interface.System_Reset'Address,
        Set_Routine => System_Reset'Access
        );

    JPATS_IOS_Interface.Register
      ( Name        => "l_brake_p",
        Variable    => This_Ios_Interface.L_Brake_Pos'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "r_brake_p",
        Variable    => This_Ios_Interface.R_Brake_Pos'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "l_brake_f",
        Variable    => This_Ios_Interface.L_Brake_F'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "r_brake_f",
        Variable    => This_Ios_Interface.R_Brake_F'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "long_stick_pos",
        Variable    => This_Ios_Interface.Long_Stk_Pos'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "long_stick_f",
        Variable    => This_Ios_Interface.Long_Stk_F'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "lat_stick_pos",
        Variable    => This_Ios_Interface.Lat_Stk_Pos'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "lat_stick_f",
        Variable    => This_Ios_Interface.Lat_Stk_F'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "pedal_pos",
        Variable    => This_Ios_Interface.Pedal_Pos'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "pedal_f",
        Variable    => This_Ios_Interface.Pedal_F'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "avg_ail",
        Variable    => This_Ios_Interface.Avg_Ail'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "mach",
        Variable    => This_Ios_Interface.Mach'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "density",
        Variable    => This_Ios_Interface.Density'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "OAT",
        Variable    => This_Ios_Interface.Oat'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "PLA",
        Variable    => This_Ios_Interface.Pla'Address
        );

    JPATS_IOS_Interface.Register
      ( Name        => "Slewing",
        Variable    => This_Ios_Interface.Slewing'Address
        );


    JPATS_IOS_Interface.Register
      ( Name        => "trim request",
        Variable    => This_Ios_Interface.Trim_Request'Address
        );

  end Register_Ios_Variables;

end JPATS_Simulated_Aircraft.IOS_Interface;
