-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package JPATS_Simulated_Aircraft.IO_Interface is
  
  type Instance is
     record
       The_Crash_Override_Amber    : Boolean := False;
       The_Crash_Override_Green    : Boolean := False;
       The_Crash_Override_On       : Boolean := False;
       
       System_Reset_On             : Boolean; --di
       System_Reset_Amber          : Boolean; --do
       System_Reset_Green          : Boolean; --do
       
       
       Total_Freeze_On             : Boolean; --di
       Total_Amber                 : Boolean; --do
       Total_Green                 : Boolean; --do
     end record;
  
  for Instance use
     record
       
       The_Crash_Override_Amber   at 004 range 0..31;
       The_Crash_Override_Green   at 008 range 0..31;
       The_Crash_Override_On      at 012 range 0..31;
       
       System_Reset_On            at 016 range 0..31;
       System_Reset_Amber         at 020 range 0..31;
       System_Reset_Green         at 024 range 0..31;
       
       Total_Freeze_On            at 028 range 0..31;
       Total_Amber                at 032 range 0..31;
       Total_Green                at 036 range 0..31;
       
     end record;
  
  This_IO_Interface : Instance;
  
  procedure Register_Io_Variables;
  
end JPATS_Simulated_Aircraft.IO_Interface;

