-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Howard Landmann
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Io;
with Jpats_Io_Types;
with Io_Types;

package body JPATS_Simulated_Aircraft.IO_Interface is

  procedure Register_Io_Variables is
    
  begin
    -- register ios hardware buttons & lights
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "Crash_Override_Amber",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.The_Crash_Override_Amber'Address,
       A_Size          => This_Io_Interface.The_Crash_Override_Amber'Size);
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "Crash_Override_green",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.The_Crash_Override_Green'Address,
       A_Size          => This_Io_Interface.The_Crash_Override_Green'Size);
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "crash_override_on",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.The_Crash_Override_On'Address,
       A_Size          => This_Io_Interface.The_Crash_Override_On'Size);
    
    --*************************************************************************************************
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "TOTAL_AMBER",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.TOTAL_AMBER'Address,
       A_Size          => This_Io_Interface.TOTAL_AMBER'Size);
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "TOTAL_GREEN",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.TOTAL_GREEN'Address,
       A_Size          => This_Io_Interface.TOTAL_GREEN'Size);
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "TOTAL_FREEZE_ON",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.TOTAL_FREEZE_ON'Address,
       A_Size          => This_Io_Interface.TOTAL_FREEZE_ON'Size);
    
    --*************************************************************************************************
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "SYS_RESET_AMBER",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.System_Reset_Amber'Address,
       A_Size          => This_Io_Interface.System_Reset_Amber'Size);
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "SYS_RESET_GREEN",
       A_Direction     => Io_Types.Output,
       An_Address      => This_Io_Interface.System_Reset_Green'Address,
       A_Size          => This_Io_Interface.System_Reset_Green'Size);
    
    JPATS_IO.Map_To_Icd_Mnemonic
      (An_Interface    => Jpats_Io_Types.Flight_Deck,
       An_Icd_Mnemonic => "SYS_RESET_ON",
       A_Direction     => Io_Types.Input,
       An_Address      => This_Io_Interface.System_Reset_On'Address,
       A_Size          => This_Io_Interface.System_Reset_On'Size);
    
  end Register_Io_Variables;

end JPATS_Simulated_Aircraft.IO_Interface;

