-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Howard Landmann
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Acceleration;
with Aerodynamic_Angle;
with Aircraft_Weight;
with Airspeed;
with Attitude_Angle;
with Location;
with Moment_of_Inertia;
with Reference_Coordinates;
with Quaternion;
with Velocity;

with Angle_Types;
with Length_Types;


private package JPATS_Simulated_Aircraft.Container is

    type Instance is
        record
            The_Acceleration                          : Acceleration.Instance;
            The_Aerodynamic_Angle                     : Aerodynamic_Angle.Instance;
            The_Aircraft_Weight                       : Aircraft_Weight.Instance;
            The_Airspeed                              : Airspeed.Instance;
            The_Attitude_Angle                        : Attitude_Angle.Instance;
            The_Location                              : Location.Instance;
            The_Moment_of_Inertia                     : Moment_of_Inertia.Instance;
            The_Quaternion                            : Quaternion.Instance;
            The_Reference_Coordinates                 : Reference_Coordinates.Instance;
            The_Velocity                              : Velocity.Instance;
            Slew_in_progress                          : Boolean := False;
            Buffet_Intens                             : Float   := 0.0;
            Terrain_Height                            : Length_Types.Feet := -1081.0;
            As_Count                                  : Integer := 0;
            Latch_Count                               : Integer := 0;
            Override_Latch                            : Boolean := False;
            Ground_Speed                              : Float := 0.0;
            Total_Freeze_On_Last_Pass                 : Boolean := False;
            Alt_Slew                                  : Boolean := False;
            Delta_Hdg                                 : Float := 0.0;
            Slewing_Timer                             : Float := 0.0;
            Hdg_Slew                                  : Float := 0.000873;
            Old_Cmnd_Alt                              : Float := 0.0;
            Old_Cmnd_Hdg                              : Float := 0.0;
            Delta_Alt                                 : Float := 0.0;
            Runway                                    : Integer := 0;
            Old_Runway                                : Integer := 0;
            System_Reset_Timer                        : Float := 0.0; -- used in system reset logic
            System_Reset_Flag                         : Boolean := False;
            Set_Cas                                   : Boolean := False;
            Repo_Active                               : Boolean := False;
            Number_Of_Pilots                          : Integer := 1;
            The_Fuselage_Collision_Counter            : Integer := 0;
            The_Left_Wing_Collision_Counter           : Integer := 0;
            The_Right_Wing_Collision_Counter          : Integer := 0;
            The_Fuselage_Collision_Last_Pass          : Boolean := False;
            The_Left_Wing_Collision_Last_Pass         : Boolean := False;
            The_Right_Wing_Collision_Last_Pass        : Boolean := False;
        end record;

        This_Subsystem : Instance;

end JPATS_Simulated_Aircraft.Container;

