-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with System;
with Ada.Strings.Bounded;
with Angle_Types, Lat_Long_Types, Length_Types;
with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Landing_Gear_Types;
with Ada.Streams;

package Jpats_Formation_Types is

   -- This is a completely arbitrary number.  It affects the size of
   -- the segment offset array
   Max_Segments : constant := 50;
--   type Segment_Type is new Natural range 0 .. Max_Segments;
   subtype Segment_Type is Natural range 0 .. Max_Segments;
   subtype Valid_Segment_Type is Segment_Type range 1 .. Max_Segments;

   type Segment_Offset_Array is
     array ( Valid_Segment_Type ) of Natural;

   -- On disk, a profile consists of a short header, a fixed-length
   -- segment offset array, indicating the index of the snapshot
   -- beginning each segment, and some number of snapshots.
   type Profile_Header is
      record
         The_Segment_Count : Segment_Type := 0;
         The_Snapshot_Count : Natural := 0;
         The_Segment_Offset_Array : Segment_Offset_Array
           := ( others => 0 );
      end record;

   Profile_Header_Size : Natural
     := (Profile_Header'Size + (System.Storage_Unit - 1)) / System.Storage_Unit;

   type Prerecorded_Profile_Snapshot is
      record
         The_Pitch   : Angle_Types.Radians := 0.0;
         The_Roll    : Angle_Types.Radians := 0.0;
         The_Heading : Angle_Types.Radians := 0.0;
         The_Latitude  : Lat_Long_Types.Latitude_Degrees := 0.0;
         The_Longitude : Lat_Long_Types.Longitude_Degrees := 0.0;
         The_Altitude  : Length_Types.Feet := 0.0;
         The_Mean_Flap_Position :
           Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type := 0.0;
         The_Speedbrake_Position :
           Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type := 0.0;
         The_Mean_Landing_Gear_Position :
           Jpats_Landing_Gear_Types.Gear_Position_Type := 1.0;
         The_Indicated_Airspeed : Float := 0.0;
         The_Elevator_Position : Angle_Types.Degrees := 0.0;
         The_Rudder_Position : Angle_Types.Degrees := 0.0;
         The_Right_Aileron_Position : Angle_Types.Degrees := 0.0;
         The_Left_Aileron_Position : Angle_Types.Degrees := 0.0;
      end record;


   procedure Write
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : in Prerecorded_Profile_Snapshot);

   procedure Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : out Prerecorded_Profile_Snapshot);

   for Prerecorded_Profile_Snapshot'Write use Write;
   for Prerecorded_Profile_Snapshot'Read use Read;

   Init_PPS : Prerecorded_Profile_Snapshot;
   Init_Header : Profile_Header;

   Profile_Snapshot_Size : Natural
     := (Prerecorded_Profile_Snapshot'Size + (System.Storage_Unit - 1)) / System.Storage_Unit;

   type Formation_Profile_Recorder_State is
     ( Idle, Initializing, Recording, Paused, Finishing );

   type Formation_Profile_Playback_State is
     ( Idle, Initializing, Playback, Paused, Finishing );


   package Bounded_16 is new Ada.Strings.Bounded.Generic_Bounded_Length(16);
   subtype Track_Name_Type is Bounded_16.Bounded_String;

end Jpats_Formation_Types;
