-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Unchecked_Conversion;
with Log;

package body Jpats_Formation_Types is

   Bytes_Per_Element  : constant := (Ada.Streams.Stream_Element'Size + 7) / 8;
   Bytes_Per_Instance : constant Natural := (Prerecorded_Profile_Snapshot'Size + 7) / 8;

   Elements_Per_Header : constant Ada.Streams.Stream_Element_Offset :=
     Ada.Streams.Stream_Element_Offset(
       (Bytes_Per_Instance + (Bytes_Per_Element - 1)) / Bytes_Per_Element);

   subtype Header_Array is Ada.Streams.Stream_Element_Array (1 .. Elements_Per_Header);

   function From_Prerecorded_Profile_Snapshot is new Unchecked_Conversion
     (Source => Prerecorded_Profile_Snapshot,
      Target => Header_Array);

   function To_Prerecorded_Profile_Snapshot is new Unchecked_Conversion
     (Source => Header_Array,
      Target => Prerecorded_Profile_Snapshot);


   procedure Write
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : in Prerecorded_Profile_Snapshot)
   is


   begin

      Ada.Streams.Write
        (Stream => Stream.all,
         Item   => From_Prerecorded_Profile_Snapshot(Item));

   exception
      when others =>
         Log.Report("Jpats_Formation_Types.Write()");
         raise;
   end Write;


   procedure Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : out Prerecorded_Profile_Snapshot)
   is

      Temp : Ada.Streams.Stream_Element_Offset;
      Item_Elements : Header_Array;

   begin

      Ada.Streams.Read
        (Stream => Stream.all,
         Item   => Item_Elements,
         Last   => Temp);

      Item := To_Prerecorded_Profile_Snapshot (Item_Elements);

   exception
      when others =>
         Log.Report("Jpats_Formation_Types.Read()");
         raise;
   end Read;




end Jpats_Formation_Types;
