-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Formation_Types;
package Jpats_Formation_Profile_Recorder is

   -- This package implements a simple state machine with five
   -- states -- Idle, Initializing, Recording, Paused, Finishing and
   -- four possible events, all of which are requests to change state.
   -- The events are requests to start recording, end the current
   -- segment (pausing recording and marking the snapshot), rewind to
   -- the beginning of the current segment (allowing the instructor to
   -- "record over" a mistake), and end the profile.

   -- The recorded profile is written to a file on a RAM disk and when
   -- the profile is complete the file is copied to a known location
   -- the hard drive.  The IOS can then move the file where the
   -- instructor pleases.

   -- This package only controls the collection and storage of a
   -- profile.  Another software subsystem will handle coordination of
   -- this recorder with the rest of simulation -- for example,
   -- dealing with a flight freeze during recording.

   function State return Jpats_Formation_Types.Formation_Profile_Recorder_State;

   procedure Start_Recording;
   -- instruct the recorder to start a new profile, or to resume
   -- recording after a pause

   procedure End_Profile_Segment;
   -- instruct the recorder to pause recording and mark the current
   -- snapshot as the end of a profile segment

   procedure Rewind_To_Start_Of_Current_Segment;
   -- instruct the recorder to go back to the beginning of the current
   -- segment, so as to record over it.

   procedure Complete_Profile;
   -- instruct the recorder to stop recording and copy the file from
   -- memory to disk

end Jpats_Formation_Profile_Recorder;
