-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Formation_Profile_Recorder.Container;
package body Jpats_Formation_Profile_Recorder is

   function State return Jpats_Formation_Types.Formation_Profile_Recorder_State is
   begin
      return Container.This_Subsystem.The_State;
   end State;

   procedure Start_Recording is 
   begin
      Container.This_Subsystem.Recording_Start_Requested := True;
   end Start_Recording;

   procedure End_Profile_Segment is
   begin
      Container.This_Subsystem.Segment_End_Requested := True;
   end End_Profile_Segment;

   procedure Rewind_To_Start_Of_Current_Segment is
   begin
      Container.This_Subsystem.Segment_Rewind_Requested := True;
   end Rewind_To_Start_Of_Current_Segment;

   procedure Complete_Profile is
   begin
      Container.This_Subsystem.Profile_Done_Requested := True;
   end Complete_Profile;

end Jpats_Formation_Profile_Recorder;
