-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Log;
package body Jpats_Formation_Profile_Recorder.Container is


   procedure Write
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : in Instance)
   is
   begin

      Jpats_Formation_Types.Formation_Profile_Recorder_State'Write
        (Stream,
         Item.The_State
         );
      Boolean'Write
        (Stream,
         Item.Recording_Start_Requested
         );
      Boolean'Write
        (Stream,
         Item.Segment_End_Requested
         );
      Boolean'Write
        (Stream,
         Item.Segment_Rewind_Requested
         );
      Boolean'Write
        (Stream,
         Item.Profile_Done_Requested
         );
      Jpats_Formation_Types.Profile_Header'Write
        (Stream,
         Item.The_Header
         );

      --         The_Temporary_File : Ada.Streams.Stream_Io.File_Type;

--       Ada.Streams.Stream_Io.Stream_Access'Write
--         (Stream,
--          Item.The_File_Stream
--          );

      Ada.Streams.Stream_Io.Positive_Count'Write
        (Stream,
         Item.The_Current_Segment_Start_Index
         );

   exception
      when others =>
         Log.Report("Jpats_Formation_Profile_Recorder.Container.Write()");
         raise;
   end Write;

   procedure Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : out Instance)
   is
   begin

      Jpats_Formation_Types.Formation_Profile_Recorder_State'Read
        (Stream,
         Item.The_State
         );
      Boolean'Read
        (Stream,
         Item.Recording_Start_Requested
         );
      Boolean'Read
        (Stream,
         Item.Segment_End_Requested
         );
      Boolean'Read
        (Stream,
         Item.Segment_Rewind_Requested
         );
      Boolean'Read
        (Stream,
         Item.Profile_Done_Requested
         );
      Jpats_Formation_Types.Profile_Header'Read
        (Stream,
         Item.The_Header
         );

      --         The_Temporary_File : Ada.Streams.Stream_Io.File_Type;

--       Ada.Streams.Stream_Io.Stream_Access'Read
--         (Stream,
--          Item.The_File_Stream
--          );

      Ada.Streams.Stream_Io.Positive_Count'Read
        (Stream,
         Item.The_Current_Segment_Start_Index
         );

   exception
      when others =>
         Log.Report("Jpats_Formation_Profile_Recorder.Container.Read()");
         raise;
   end Read;


end Jpats_Formation_Profile_Recorder.Container;
