-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Angle_Types, Lat_Long_Types, Length_Types;
with Jpats_Secondary_Flight_Controls_Types;
with Jpats_Landing_Gear_Types;
with Jpats_Formation_Types;
with Ada.Streams.Stream_IO;

package Jpats_Formation_Profile_Playback is

   -- This package implements a simple state machine with five
   -- states -- Idle, Initializing, Playing, Paused, Finishing and
   -- five possible events, all of which are requests to change state.
   -- The events are requests to start playing, rewind to
   -- the beginning of the current segment, go directly to a specific segment,
   -- pause playback, and stop and reset playback.

   -- The playback file is copied from a known location on the hard
   -- drive to a file on a RAM disk, for speed of access during
   -- playback.

   -- This package only controls the reading and playback of a
   -- profile.  Another software subsystem will handle coordination of
   -- this playback system with the rest of simulation -- for example,
   -- dealing with a flight freeze during playback.

   function State
     return Jpats_Formation_Types.Formation_Profile_Playback_State;

   procedure Start_Playback;
   -- instruct the player to start a new profile, or to resume
   -- recording after a pause

   procedure Rewind_To_Start_Of_Current_Segment;
   -- instruct the player to go back to the beginning of the current
   -- segment

   procedure Go_To_Segment ( A_Segment : in Natural );
   -- instruct the recorder to go to the beginning of the specified
   -- segment.

   procedure Pause_Playback;
   -- instruct the recorder to pause playback at current snapshot

   procedure Stop_Playback;
   -- instruct the recorder to stop playback and reset

   function Pitch return Angle_Types.Radians;
   function Roll return Angle_Types.Radians;
   function Heading return Angle_Types.Radians;
   function Latitude return Lat_Long_Types.Latitude_Degrees;
   function Longitude return Lat_Long_Types.Longitude_Degrees;
   function Altitude return Length_Types.Feet;
   function Mean_Flap_Position
     return Jpats_Secondary_Flight_Controls_Types.Flap_Position_Type;
   function Speedbrake_Position
     return Jpats_Secondary_Flight_Controls_Types.Speedbrake_Position_Type;
   function Elevator_Position
     return Angle_Types.Degrees;
   function Rudder_Position
     return Angle_Types.Degrees;
   function Right_Aileron_Position
     return Angle_Types.Degrees;
   function Left_Aileron_Position
     return Angle_Types.Degrees;
   function Mean_Landing_Gear_Position
     return Jpats_Landing_Gear_Types.Gear_Position_Type;
   function Indicated_Airspeed return Length_Types.Knots;

   function Current_Track_Number return Integer;

   function Playback_Is_Active return Boolean;
   function Current_Playback_File_Index return Ada.Streams.Stream_IO.Positive_Count;

   type File_Access is access all Ada.Streams.Stream_Io.File_Type;

   function The_Temporary_File return File_Access;

end Jpats_Formation_Profile_Playback;
