-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Formation_Types;
with Ada.Streams.Stream_Io;
private package Jpats_Formation_Profile_Playback.Container is

   type Instance is
      record
         The_State : Jpats_Formation_Types.Formation_Profile_Playback_State := Jpats_Formation_Types.Idle;
         Playback_Start_Requested : Boolean := False;
         Playback_Pause_Requested : Boolean := False;
         Segment_Rewind_Requested : Boolean := False;
         Segment_Goto_Requested : Boolean := False;
         The_Selected_Segment : Jpats_Formation_Types.Segment_Type := 0;
         Profile_Done_Requested : Boolean := False;
         The_Header : Jpats_Formation_Types.Profile_Header := Jpats_Formation_Types.Init_Header;
         The_Temporary_File : aliased Ada.Streams.Stream_Io.File_Type;
         The_File_Stream : Ada.Streams.Stream_Io.Stream_Access;
         The_Current_Segment_Start_Index : Ada.Streams.Stream_Io.Positive_Count := 1;
         The_Current_Snapshot : Jpats_Formation_Types.Prerecorded_Profile_Snapshot := Jpats_Formation_Types.Init_PPS;


         The_Segment_Index : Jpats_Formation_Types.Segment_Type := 0;
         The_Snapshot_Index : Natural := 0;

         Playback_Is_Active          : Boolean := False;
         Current_Playback_File_Index : Ada.Streams.Stream_IO.Positive_Count := 1;

         FPPC_State_Lp : Jpats_Formation_Types.Formation_Profile_Playback_State;

         FPPC_Freeze_Lp : Boolean := False;

      end record;

   procedure Write
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : in Instance);

   procedure Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : out Instance);

   for Instance'Write use Write;
   for Instance'Read use Read;

   This_Subsystem : Instance;

end Jpats_Formation_Profile_Playback.Container;
