-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Mike Bates
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Log;
package body Jpats_Formation_Profile_Playback.Container is


   procedure Write
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : in Instance)
   is
   begin

      Jpats_Formation_Types.Formation_Profile_Playback_State'Write
        (Stream,
         Item.The_State
           );

      Boolean'Write
        (Stream,
         Item.Playback_Start_Requested
           );

      Boolean'Write
        (Stream,
         Item.Playback_Pause_Requested
           );

      Boolean'Write
        (Stream,
         Item.Segment_Rewind_Requested
           );

      Boolean'Write
        (Stream,
         Item.Segment_Goto_Requested
           );

      Jpats_Formation_Types.Segment_Type'Write
        (Stream,
         Item.The_Selected_Segment
           );

      Boolean'Write
        (Stream,
         Item.Profile_Done_Requested
           );

      Jpats_Formation_Types.Profile_Header'Write
        (Stream,
         Item.The_Header
           );

      --  The_Temporary_File : Ada.Streams.Stream_Io.File_Type

--       Ada.Streams.Stream_Io.Stream_Access'Write
--         (Stream,
--          Item.The_File_Stream
--            );

      Ada.Streams.Stream_Io.Positive_Count'Write
        (Stream,
         Item.The_Current_Segment_Start_Index
           );

      Jpats_Formation_Types.Prerecorded_Profile_Snapshot'Write
        (Stream,
         Item.The_Current_Snapshot
           );


      Jpats_Formation_Types.Segment_Type'Write
        (Stream,
         Item.The_Segment_Index
           );

      Natural'Write
        (Stream,
         Item.The_Snapshot_Index
           );

      Boolean'Write
        (Stream,
         Item.Playback_Is_Active
         );

      Ada.Streams.Stream_Io.Positive_Count'Write
        (Stream,
         Item.Current_Playback_File_Index
         );

   exception
      when others =>
         Log.Report("Jpats_Formation_Profile_Playback.Container.Write()");
         raise;
   end Write;

   procedure Read
     (Stream : access Ada.Streams.Root_Stream_Type'Class;
      Item   : out Instance)
   is
   begin

      begin
         Jpats_Formation_Types.Formation_Profile_Playback_State'Read
           (Stream,
            Item.The_State
            );
      exception
         when others =>
            Log.Report("Jpats_Formation_Types.Formation_Profile_Playback_State'Read() bombed on Item.The_State");
            raise;
      end;

      begin
         Boolean'Read
           (Stream,
            Item.Playback_Start_Requested
            );
      exception
         when others =>
            Log.Report("Boolean'Read() bombed on Item.Playback_Start_Requested");
            raise;
      end;

      begin
         Boolean'Read
           (Stream,
            Item.Playback_Pause_Requested
            );
      exception
         when others =>
            Log.Report("Boolean'Read() bombed on Item.Playback_Pause_Requested");
            raise;
      end;

      begin
         Boolean'Read
           (Stream,
            Item.Segment_Rewind_Requested
            );
      exception
         when others =>
            Log.Report("Boolean'Read() bombed on Item.Segment_Rewind_Requested");
            raise;
      end;

      begin
         Boolean'Read
           (Stream,
            Item.Segment_Goto_Requested
            );
      exception
         when others =>
            Log.Report("Boolean'Read() bombed on Item.Segment_Goto_Requested");
            raise;
      end;

      begin
         Jpats_Formation_Types.Segment_Type'Read
           (Stream,
            Item.The_Selected_Segment
            );
      exception
         when others =>
            Log.Report("Jpats_Formation_Types.Segment_Type'Read() bombed on Item.The_Selected_Segment");
            raise;
      end;

      begin
         Boolean'Read
           (Stream,
            Item.Profile_Done_Requested
            );
      exception
         when others =>
            Log.Report("Boolean'Read() bombed on Item.Profile_Done_Requested");
            raise;
      end;

      begin
         Jpats_Formation_Types.Profile_Header'Read
           (Stream,
            Item.The_Header
            );
      exception
         when others =>
            Log.Report("Jpats_Formation_Types.Profile_Header'Read() bombed on Item.The_Header");
            raise;
      end;

      --  The_Temporary_File : Ada.Streams.Stream_Io.File_Type

--       Ada.Streams.Stream_Io.Stream_Access'Read
--         (Stream,
--          Item.The_File_Stream
--            );

      begin
         Ada.Streams.Stream_Io.Positive_Count'Read
           (Stream,
            Item.The_Current_Segment_Start_Index
            );
      exception
         when others =>
            Log.Report("Ada.Streams.Stream_Io.Positive_Count'Read() bombed on Item.The_Current_Segment_Start_Index");
            raise;
      end;

      begin
         Jpats_Formation_Types.Prerecorded_Profile_Snapshot'Read
           (Stream,
            Item.The_Current_Snapshot
            );
      exception
         when others =>
            Log.Report("Jpats_Formation_Types.Prerecorded_Profile_Snapshot'Read() bombed on Item.The_Current_Snapshot");
            raise;
      end;


      begin
         Jpats_Formation_Types.Segment_Type'Read
           (Stream,
            Item.The_Segment_Index
            );
      exception
         when others =>
            Log.Report("Jpats_Formation_Types.Segment_Type'Read() bombed on Item.The_Segment_Index");
            raise;
      end;

      begin
         Natural'Read
           (Stream,
            Item.The_Snapshot_Index
            );
      exception
         when others =>
            Log.Report("Natural'Read() bombed on Item.The_Snapshot_Index");
            raise;
      end;

      begin
         Boolean'Read
           (Stream,
            Item.Playback_Is_Active
            );
      exception
         when others =>
            Log.Report("Boolean'Read() bombed on Item.Playback_Is_Active");
            raise;
      end;

      begin
         Ada.Streams.Stream_Io.Positive_Count'Read
           (Stream,
            Item.Current_Playback_File_Index
            );
      exception
         when others =>
            Log.Report("Ada.Streams.Stream_Io.Positive_Count'Read() bombed on Item.Current_Playback_File_Index");
            raise;
      end;

   exception
      when others =>
         Log.Report("Jpats_Formation_Profile_Playback.Container.Read()");
         raise;
   end Read;

end Jpats_Formation_Profile_Playback.Container;
