-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

package Jpats_Formation_Manager is

   function Kinematic_Driver return Boolean;
   function Lead_Pitch_Angle return Float;
   function Lead_Bank_Angle return Float;
   function Lead_Heading return Float;
   function Lead_Latitude return Long_Float;
   function Lead_Longitude return Long_Float;
   function Lead_Geometric_Altitude return Float;
   function Lead_Flap_Position return Float;
   function Lead_Speedbrake_Position return Float;
   function Lead_Elevator_Position return Float;
   function Lead_Rudder_Position return Float;
   function Lead_Right_Aileron_Position return Float;
   function Lead_Left_Aileron_Position return Float;
   function Lead_Gear_Position return Float;
   function Display_Lead return Boolean;
   function Lead_True_Airspeed return Float;
   function Lead_Indicated_Airspeed return Float;
   function Flight_Freeze_Request return Boolean;
   function Profile_Driver return Boolean;
   procedure Set_Profile_Driver(Switch : in Boolean);
   procedure Set_Init_Formation_Demo_Lp(Switch : in Boolean);
   function Get_Formation_Track_Number return Integer;
   procedure Set_Formation_Track_Number( Track : in Integer);

end Jpats_Formation_Manager;
