-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------
with Jpats_Formation_Manager.Container;
with Jpats_Formation_Manager.Controller;
with Formation_Lead_Kinematic;
with Log;

package body Jpats_Formation_Manager is

   package Ctnr renames Container;
   package Lead_Kinematic renames Formation_Lead_Kinematic;
   Lead : Ctnr.Formation_Lead_Instance renames  Ctnr.The_Lead;

   function Kinematic_Driver
     return Boolean is
   begin
      return Ctnr.This_Ios_Interface.Kinematic_Driver;
   end Kinematic_Driver;

   function Lead_Indicated_Airspeed
     return Float
   is
      Ft_Per_Sec_To_Knots : constant Float := 0.5924838;

      V_I : constant Float := Lead.V_Indicated_Airspeed * Ft_Per_Sec_To_Knots;
   begin
      return V_I;
   exception
      when others =>
         Log.Report("");
         raise;
   end Lead_Indicated_Airspeed;

   function Lead_True_Airspeed
     return Float
   is
      Ft_Per_Sec_To_Knots : constant Float := 0.5924838;

      V_T : constant Float := Lead.V_True_Airspeed * Ft_Per_Sec_To_Knots;
   begin
      return V_T;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_True_Airspeed()");
         raise;
   end Lead_True_Airspeed;

   function Lead_Bank_Angle
     return Float
   is
   begin
      if Kinematic_Driver then
         return Lead_Kinematic.Bank_angle(Lead.Kinematic_Driver);
      else
         return Lead.Bank_Angle;
      end if;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Bank_Angle()");
         raise;
   end Lead_Bank_Angle;

   function Lead_Flap_Position
     return Float
   is
   begin
      return Lead.Flap_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Flap_Position()");
         raise;
   end Lead_Flap_Position;

   function Lead_Gear_Position
     return Float
   is
   begin
      return Lead.Gear_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Gear_Position()");
         raise;
   end Lead_Gear_Position;

   function Lead_Geometric_Altitude
     return Float
   is
   begin
      return Lead.Geometric_Altitude;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Geometric_Altitude()");
         raise;
   end Lead_Geometric_Altitude;

   function Lead_Heading
     return Float
   is
   begin
      return Lead.Heading;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Heading()");
         raise;
   end Lead_Heading;

   function Lead_Latitude
     return Long_Float
   is
   begin
      return Lead.Latitude;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Latitude()");
         raise;
   end Lead_Latitude;

   function Lead_Longitude
     return Long_Float
   is
   begin
      return Lead.Longitude;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Longitude()");
         raise;
   end Lead_Longitude;

   function Lead_Pitch_Angle
     return Float
   is
   begin
      if Kinematic_Driver then
         return Lead_Kinematic.Pitch_angle(Lead.Kinematic_Driver);
      else
         return Lead.Pitch_Angle;
      end if;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Pitch_Angle()");
         raise;
   end Lead_Pitch_Angle;

   function Lead_Speedbrake_Position
     return Float
   is
   begin
      return Lead.Speedbrake_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Speedbrake_Position()");
         raise;
   end Lead_Speedbrake_Position;

   function Lead_Elevator_Position
     return Float
   is
   begin
      return Lead.Elevator_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Elevator_Position()");
         raise;
   end Lead_Elevator_Position;

   function Lead_Rudder_Position
     return Float
   is
   begin
      return Lead.Rudder_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Rudder_Position()");
         raise;
   end Lead_Rudder_Position;

   function Lead_Right_Aileron_Position
     return Float
   is
   begin
      return Lead.Right_Aileron_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Right_Aileron_Position()");
         raise;
   end Lead_Right_Aileron_Position;

   function Lead_Left_Aileron_Position
     return Float
   is
   begin
      return Lead.Left_Aileron_Position;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Lead_Left_Aileron_Position()");
         raise;
   end Lead_Left_Aileron_Position;

   function Display_Lead
     return Boolean
   is
   begin
      return Lead.Is_Active;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Display_Lead()");
         raise;
   end Display_Lead;

   function Flight_Freeze_Request
     return Boolean
   is
   begin
      return Controller.Freeze_Request;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Flight_Freeze_Request");
         raise;
   end Flight_Freeze_Request;

   function Profile_Driver
     return Boolean is
   begin
      return Ctnr.This_Ios_Interface.Profile_Driver;
   end Profile_Driver;

   -- Not an accessor. Mutator
   procedure Set_Profile_Driver(Switch : in Boolean) is
   begin
      Ctnr.This_Ios_Interface.Profile_Driver := Switch;
   end Set_Profile_Driver;

   -- Not an accessor. Mutator
   procedure Set_Init_Formation_Demo_Lp(Switch : in Boolean) is
   begin
      Controller.Init_Formation_Demo_Lp := Switch;
   end Set_Init_Formation_Demo_Lp;

   function Get_Formation_Track_Number
     return Integer is
   begin
     return Ctnr.This_Ios_Interface.Formation_Track_Number;
   end Get_Formation_Track_Number;

   procedure Set_Formation_Track_Number( Track : in Integer) is
   begin
      Ctnr.This_Ios_Interface.Formation_Track_Number := Track;
   end Set_Formation_Track_Number;

end Jpats_Formation_Manager;
