-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Jpats_Formation_Manager.Container;
with Jpats_Ios_Interface;
with Log;
with Jpats_Formation_Types;


package body Jpats_Formation_Manager.Ios_Interface is

   package Ctnr renames Container;
   Ios : Ctnr.Ios_Interface_Instance renames Ctnr.This_Ios_Interface;
   The_Lead : Ctnr.Formation_Lead_Instance renames Ctnr.The_Lead;

   package JII renames Jpats_Ios_Interface;


   procedure Set_Formation_Track_1_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_1_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_1_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_1_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));

       Ios.Formation_Track_1_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_1_Name_R()");
         raise;
   end Set_Formation_Track_1_Name_R;
   procedure Set_Formation_Track_2_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_2_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_2_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_2_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_2_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_2_Name_R()");
         raise;
   end Set_Formation_Track_2_Name_R;
   procedure Set_Formation_Track_3_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_3_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_3_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_3_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_3_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_3_Name_R()");
         raise;
   end Set_Formation_Track_3_Name_R;
   procedure Set_Formation_Track_4_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_4_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_4_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_4_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_4_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_4_Name_R()");
         raise;
   end Set_Formation_Track_4_Name_R;
   procedure Set_Formation_Track_5_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_5_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_5_Name_R(Offset1d+1) := ' ';
      else
--       Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_5_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_5_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_5_Name_R()");
         raise;
   end Set_Formation_Track_5_Name_R;
   procedure Set_Formation_Track_6_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_6_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_6_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_6_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_6_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_6_Name_R()");
         raise;
   end Set_Formation_Track_6_Name_R;
   procedure Set_Formation_Track_7_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_7_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_7_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_7_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_7_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_7_Name_R()");
         raise;
   end Set_Formation_Track_7_Name_R;
   procedure Set_Formation_Track_8_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_8_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_8_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_8_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_8_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_8_Name_R()");
         raise;
   end  Set_Formation_Track_8_Name_R;
   procedure Set_Formation_Track_9_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_9_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_9_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_9_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_9_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_9_Name_R()");
         raise;
   end Set_Formation_Track_9_Name_R;
   procedure Set_Formation_Track_10_Name_R
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      if JII.Convert_To_Integer(Pdata) = 0 then
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_10_Name_R, Offset1d+1, ' ');
         Ios.Formation_Track_10_Name_R(Offset1d+1) := ' ';
      else
--         Jpats_Formation_Types.Bounded_16.Replace_Element(Ios.Formation_Track_10_Name_R, Offset1d+1, JII.Convert_To_Character(Pdata));
         Ios.Formation_Track_10_Name_R(Offset1d+1) := JII.Convert_To_Character(Pdata);
      end if;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_10_Name_R()");
         raise;
   end Set_Formation_Track_10_Name_R;


   procedure Set_Formation_Track_1_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_1_Name;
   procedure Set_Formation_Track_2_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_2_Name;
   procedure Set_Formation_Track_3_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_3_Name;
   procedure Set_Formation_Track_4_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_4_Name;
   procedure Set_Formation_Track_5_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_5_Name;
   procedure Set_Formation_Track_6_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_6_Name;
   procedure Set_Formation_Track_7_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_7_Name;
   procedure Set_Formation_Track_8_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_8_Name;
   procedure Set_Formation_Track_9_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in    Integer;
      Completed : in    Boolean )
   is
   begin
      null;
   end Set_Formation_Track_9_Name;
   procedure Set_Formation_Track_10_Name
     (PData     : in    JPATS_IOS_Interface.Set_Value;
      Offset1d  : in    Integer;
      Offset2d  : in  Integer;
      Completed : in  Boolean )
   is
   begin
      null;
   end Set_Formation_Track_10_Name;




   procedure Pitch_Angle_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Pitch_Angle := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Pitch_Angle_Command()");
         raise;
   end Pitch_Angle_Command;

   procedure Pitch_Rate_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Pitch_Rate := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Pitch_Rate_Command()");
         raise;
   end Pitch_Rate_Command;

   procedure Bank_Angle_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Bank_Angle := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Bank_Angle_Command()");
         raise;
   end Bank_Angle_Command;

   procedure Roll_Rate_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Roll_Rate := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Roll_Rate_Command()");
         raise;
   end Roll_Rate_Command;

   procedure Indicated_Airspeed_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Indicated_Airspeed := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Indicated_Airspeed_Command()");
         raise;
   end Indicated_Airspeed_Command;

   procedure Airspeed_Acceleration_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Airspeed_Acceleration := JII.Convert_To_Float(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Airspeed_Acceleration_Command()");
         raise;
   end Airspeed_Acceleration_Command;

   procedure Kinematic_Driver_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Kinematic_Driver := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Kinematic_Driver_Command()");
         raise;
   end Kinematic_Driver_Command;

   procedure Profile_Driver_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Profile_Driver := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Profile_Driver_Command()");
         raise;
   end Profile_Driver_Command;


   procedure Recorder_On_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Recorder_On := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Recorder_On_Command()");
         raise;
   end Recorder_On_Command;

   procedure  Wing_Dip_Cmd_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Wing_Dip_Cmd := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Wing_Dip_Cmd_Command()");
         raise;
   end Wing_Dip_Cmd_Command;

   procedure  Porpoise_Cmd_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Porpoise_Cmd := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Porpoise_Cmd_Command()");
         raise;
   end Porpoise_Cmd_Command;

   procedure Big_Wing_Rock_Cmd_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Big_Wing_Rock_Cmd := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Big_Wing_Rock_Cmd_Command()");
         raise;
   end Big_Wing_Rock_Cmd_Command;

   procedure Small_Wing_Rock_Cmd_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Small_Wing_Rock_Cmd := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Small_Wing_Rock_Cmd_Command()");
         raise;
   end Small_Wing_Rock_Cmd_Command;

   procedure Flaps_Up_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Flaps_Up := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Flaps_Up_Command()");
         raise;
   end Flaps_Up_Command;

   procedure Flaps_Ldg_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Flaps_Ldg := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Flaps_Ldg_Command()");
         raise;
   end Flaps_Ldg_Command;

   procedure Speedbrake_Deployed_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Speedbrake_Deployed := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Speedbrake_Deployed_Command()");
         raise;
   end Speedbrake_Deployed_Command;

   procedure Gear_Up_Command
     (PData : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Gear_Up := JII.Convert_To_Bool(PData);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Gear_Up_Command()");
         raise;
   end Gear_Up_Command;


   Load_Cmd_State_Lp : Boolean renames Container.This_Subsystem.FM_IOSI_Load_Cmd_State_Lp;
   procedure Set_Formation_Load_Cmd
     (Pdata : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Formation_Load_Cmd := JII.Convert_To_Bool(Pdata);

      Ios.Profile_Driver := False;

      Ios.Formation_Track_Number := 0;

      Load_Cmd_State_Lp := Ios.Formation_Load_Cmd;
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Load_Cmd()");
         raise;
   end Set_Formation_Load_Cmd;

   procedure  Set_Formation_Save_Cmd
     (Pdata : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Formation_Save_Cmd := JII.Convert_To_Bool(Pdata);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Save_Cmd()");
         raise;
   end Set_Formation_Save_Cmd;

   procedure  Set_Formation_Track_Number
     (Pdata : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Formation_Track_Number := JII.Convert_To_Integer(Pdata);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Track_Number()");
         raise;
   end Set_Formation_Track_Number;


   Fplp : Boolean renames Container.This_Subsystem.FM_IOSI_Fplp;
   procedure  Set_Formation_Previous_Track
     (Pdata : JPATS_IOS_Interface.Set_Value)
   is
   begin

      Fplp := Ios.Formation_Previous_Track;

      Ios.Formation_Previous_Track := JII.Convert_To_Bool(Pdata);
      if Ios.Formation_Previous_Track /= Fplp then
         Log.Report("Formation_Previous_Track changed and is " & Boolean'Image(Ios.Formation_Previous_Track));
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Previous_Track()");
         raise;
   end Set_Formation_Previous_Track;

   Fnlp : Boolean renames Container.This_Subsystem.FM_IOSI_Fnlp;
   procedure  Set_Formation_Next_Track
     (Pdata : JPATS_IOS_Interface.Set_Value)
   is
   begin

      Fnlp := Ios.Formation_Next_Track;

      Ios.Formation_Next_Track := JII.Convert_To_Bool(Pdata);
      if Ios.Formation_Next_Track /= Fnlp then
         Log.Report("Formation_Next_Track changed and is " & Boolean'Image(Ios.Formation_Next_Track));
      end if;

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Set_Formation_Next_Track()");
         raise;
   end Set_Formation_Next_Track;

   procedure Formation_Snapshot_Command
     (Pdata : JPATS_IOS_Interface.Set_Value)
   is
   begin
      Ios.Formation_Snapshot := JII.Convert_To_Bool(Pdata);
   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Formation_Snapshot_Command()");
         raise;
   end Formation_Snapshot_Command;

   procedure IOS_Set_End_Formation_Demo_Leadship_Cmd (Value : in JPATS_IOS_Interface.Set_Value) is
   begin
      End_Formation_Demo_Leadship_Cmd := JPATS_IOS_Interface.Convert_To_Bool(Value);
   end IOS_Set_End_Formation_Demo_Leadship_Cmd;

   ----------------------------
   -- Register_Ios_Variables --
   ----------------------------

   procedure Register_Ios_Variables is
   begin


      JPATS_IOS_Interface.Register
        (Name        => "XFormation_Lead_BANK_ANGLE",
         Variable    => The_lead.Bank_Angle'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "XFormation_Lead_Pitch_Angle",
         Variable    => The_lead.Pitch_Angle'Address
         );


      JPATS_IOS_Interface.Register
        (Name        => "Formation_Snapshot",
         Variable    => Ios.Formation_Snapshot'Address,
         Set_Routine => Formation_Snapshot_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Load_Cmd",
         Variable    => Ios.Formation_Load_Cmd'Address,
         Set_Routine => Set_Formation_Load_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Save_Cmd",
         Variable    => Ios.Formation_Save_Cmd'Address,
         Set_Routine => Set_Formation_Save_Cmd'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Number_Of_Tracks",
         Variable    => Ios.Formation_Number_Of_Tracks'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Track_Number",
         Variable    => Ios.Formation_Track_Number'Address,
         Set_Routine => Set_Formation_Track_Number'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Previous_Track",
         Variable    => Ios.Formation_Previous_Track'Address,
         Set_Routine => Set_Formation_Previous_Track'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Next_Track",
         Variable    => Ios.Formation_Next_Track'Address,
         Set_Routine => Set_Formation_Next_Track'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Lead_Latitude",
         Variable    => The_lead.Latitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Lead_Longitude",
         Variable    => The_lead.Longitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Lead_Geometric_Altitude",
         Variable    => The_lead.Geometric_Altitude'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Lead_V_True_Airspeed",
         Variable    => The_lead.V_True_Airspeed'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Formation_Lead_Heading",
         Variable    => The_lead.Heading'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Wing_Dip_Cmd",
         Variable    => Ios.Wing_Dip_Cmd'Address,
         Set_Routine => Wing_Dip_Cmd_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Porpoise_Cmd",
         Variable    => Ios.Porpoise_Cmd'Address,
         Set_Routine => Porpoise_Cmd_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Big_Wing_Rock_Cmd",
         Variable    => Ios.Big_Wing_Rock_Cmd'Address,
         Set_Routine => Big_Wing_Rock_Cmd_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Small_Wing_Rock_Cmd",
         Variable    => Ios.Small_Wing_Rock_Cmd'Address,
         Set_Routine => Small_Wing_Rock_Cmd_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flaps_Up",
         Variable    => Ios.Flaps_Up'Address,
         Set_Routine => Flaps_Up_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Flaps_Ldg",
         Variable    => Ios.Flaps_Ldg'Address,
         Set_Routine => Flaps_Ldg_Command'Access
         );

--       JPATS_IOS_Interface.Register
--         (Name        => "Lead_Speedbrake_Deployed",
--          Variable    => Ios.Speedbrake_Deployed'Address,
--          Set_Routine => Speedbrake_Deployed_Command'Access
--          );

      JPATS_IOS_Interface.Register
        (Name        => "Gear_Up",
         Variable    => Ios.Gear_Up'Address,
         Set_Routine => Gear_Up_Command'Access
         );


      JPATS_IOS_Interface.Register
        (Name        => "Pitch_Angle",
         Variable    => Ios.Pitch_Angle'Address,
         Set_Routine => Pitch_Angle_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Pitch_Rate",
         Variable    => Ios.Pitch_Rate'Address,
         Set_Routine => Pitch_Rate_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Bank_Angle",
         Variable    => Ios.Bank_Angle'Address,
         Set_Routine => Bank_Angle_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Roll_Rate",
         Variable    => Ios.Roll_Rate'Address,
         Set_Routine => Roll_Rate_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Indicated_Airspeed",
         Variable    => Ios.Indicated_Airspeed'Address,
         Set_Routine => Indicated_Airspeed_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Airspeed_Acceleration",
         Variable    => Ios.Airspeed_Acceleration'Address,
         Set_Routine => Airspeed_Acceleration_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Kinematic_Driver",
         Variable    => Ios.Kinematic_Driver'Address,
         Set_Routine => Kinematic_Driver_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Profile_Driver",
         Variable    => Ios.Profile_Driver'Address,
         Set_Routine => Profile_Driver_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Recorder_On",
         Variable    => Ios.Recorder_On'Address,
         Set_Routine => Recorder_On_Command'Access
         );

      JPATS_IOS_Interface.Register
        (Name        => "Ownship_Lat_Fract",
         Variable    => Ios.Ownship_Lat_Fract'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Lead_Lat_Fract",
         Variable    => Ios.Lead_Lat_Fract'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Lead_To_Ownship_Distance",
         Variable    => Ios.Lead_To_Ownship_Distance'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fm_Lead_Ias",
         Variable    => Ios.Fm_Lead_Ias'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fm_Float_1",
         Variable    => Ios.Fm_Float_1'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fm_Float_2",
         Variable    => Ios.Fm_Float_2'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fm_Float_3",
         Variable    => Ios.Fm_Float_3'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fm_Float_4",
         Variable    => Ios.Fm_Float_4'Address
         );

      JPATS_IOS_Interface.Register
        (Name        => "Fm_Float_5",
         Variable    => Ios.Fm_Float_5'Address
         );

      JPATS_IOS_Interface.Register
        (Name               => "End_Formation_Demo_Leadship_Cmd",
         Variable           => End_Formation_Demo_Leadship_Cmd'Address,
         Set_Routine        => IOS_Set_End_Formation_Demo_Leadship_Cmd'Access
         );

   exception
      when others =>
         Log.Report("Jpats_Formation_Manager.Ios_Interface.Register_Ios_Variables()");
         raise;
   end Register_Ios_Variables;

end Jpats_Formation_Manager.Ios_Interface;

