-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Formation_Lead_Kinematic;
with Jpats_Formation_Types;
with Ada.Streams.Stream_IO;

private package Jpats_Formation_Manager.Container is

   package JF_T renames Jpats_Formation_Types;
   package Bnd_16 renames JF_T.Bounded_16;

   type TrackNamesType is array (1..10) of JF_T.Track_Name_Type;
   type TrackNamesTypeR is array (1..10) of JF_T.Track_Name_Type;

   Not_Available : constant JF_T.Track_Name_Type :=
     Bnd_16.Head(Bnd_16.To_Bounded_String("N/A"),Bnd_16.Max_Length);

   type T1 is mod 1800;

   type Instance is
      record
         FMC_Kinematic_Driver_Lp   : Boolean := False;
         FMC_Profile_Driver_Lp     : Boolean := False;
         FMC_VIAS_Cmd_Lp           : Float := 0.0;
         FMC_Accel_Vias_Lp         : Float := 0.0;
         FMC_Pitch_Angle_Cmd_Lp    : Float := 0.0;
         FMC_Pitch_Rate_Lp         : Float := 0.0;
         FMC_Profile_Playback_Lp   : Boolean := False;
         FMC_Formation_Save_Cmd_Lp : Boolean := False;
         FMC_Formation_Load_Cmd_Lp : Boolean := False;
         FMC_Track_Counter_R         : Integer := 0;
         FMC_Recorder_On_Lp        : Boolean := False;
         FMC_Freeze_Rq             : Boolean := False;
         FMC_Profile_Choosen_Lp    : Boolean := False;
         FMC_Profile_Choosen       : Boolean := False; --???????????????????????????????????????????
         FMC_Flight_Freeze_Lp      : Boolean := False;
         FMC_Track_Number_Lp       : Integer := 1;
         FMC_Recorder_Initialized  : Boolean := False;
         FMC_Playback_Mode_Timer   :  T1 := 0;

         FMC_The_Name : Bnd_16.Bounded_String;
         FMC_The_Rest : Bnd_16.Bounded_String;
         FMC_Temp_String : String(1..16);

         --   Track_Names   : array (1..10) of JF_T.Track_Name_Type := (others => Ctnr.Not_Available);
         --   Track_Names_R : array (1..10) of JF_T.Track_Name_Type := (others => Ctnr.Not_Available);
         FMC_Track_Names   : TrackNamesType := (others => Not_Available);
         FMC_Track_Names_R : TrackNamesTypeR := (others => Not_Available);


         FMC_Next_Track_Lp     : Boolean := False;
         FMC_Next_Track_Timer  : Float := 0.0;
         FMC_Next_Track_Timer_2  : Float := 0.0;


         FMC_Previous_Track_Lp : Boolean := False;
         FMC_Previous_Track_Timer : float := 0.0;
         FMC_Previous_Track_Timer_2 : float := 0.0;


         FMC_Current_Track_Number_Lp : Integer := 0;

         FMC_Pause_Request : Boolean := False;
         FMC_Start_Playback_Request : boolean := False;
         FMC_Goto_Segment_Request : boolean := False;
         FMC_Goto_Segment_Request_Track_Number : Integer := 1;

         FMC_Just_Selected_Play : Boolean := False;

         FM_IOSI_Load_Cmd_State_Lp : Boolean := False;

         FM_IOSI_Fplp : Boolean := False;

         FM_IOSI_Fnlp : Boolean := False;

      end record;
   This_Subsystem : Instance;

   type Formation_Lead_Instance is
      record

         Pitch_Angle            : Float := 0.0;
         Bank_Angle             : Float := 0.0;
         Heading                : Float := 0.0;
         Latitude               : Long_Float := 0.0;
         Longitude              : Long_Float := 0.0;
         Geometric_Altitude     : Float := 0.0;
         V_Indicated_Airspeed   : Float := 0.0;
         V_True_Airspeed        : Float := 0.0;
         Gear_Position          : Float := 0.0;
         Speedbrake_Position    : Float := 0.0;
         Flap_Position          : Float := 0.0;
         Elevator_Position      : Float := 0.0;
         Rudder_Position        : Float := 0.0;
         Right_Aileron_Position : Float := 0.0;
         Left_Aileron_Position  : Float := 0.0;

         Kinematic_Driver     : Formation_Lead_Kinematic.Instance;

         Is_Active            : Boolean := False; -- for visual

      end record;
   The_Lead : Formation_Lead_Instance;


   type Ios_Interface_Instance is
      record
         Pitch_Angle            : Float := 0.0;
         Pitch_Rate             : Float := 15.0;
         Bank_Angle             : Float := 0.0;
         Roll_Rate              : Float := 15.0;
         Indicated_Airspeed     : Float := 150.0;
         Airspeed_Acceleration  : Float := 50.0;
         Kinematic_Driver       : Boolean := False;
         Profile_Driver         : Boolean := False;
         Recorder_On            : Boolean := False;

         Wing_Dip_Cmd             : Boolean := False;
         Porpoise_Cmd             : Boolean := False;
         Big_Wing_Rock_Cmd        : Boolean := False;
         Small_Wing_Rock_Cmd      : Boolean := False;
         Flaps_Up                 : Boolean := True;
         Flaps_Ldg                : Boolean := False;
         Speedbrake_Deployed      : Boolean := False;
         Gear_Up                  : Boolean := False;

         Formation_Track_1_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_2_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_3_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_4_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_5_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_6_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_7_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_8_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_9_Name   : String(1..16) := bnd_16.to_string(not_available);
         Formation_Track_10_Name  : String(1..16) := bnd_16.to_string(not_available);

         Formation_Track_1_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_2_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_3_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_4_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_5_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_6_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_7_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_8_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_9_Name_R   : String(1..16) := bnd_16.to_string(Not_Available);
         Formation_Track_10_Name_R  : String(1..16) := bnd_16.to_string(Not_Available);

         Formation_Load_Cmd                 : Boolean := False;
         Formation_Save_Cmd                 : Boolean := False;

         Formation_Number_Of_Tracks  : Integer := 0;
         Formation_Track_Number      : Integer := 1;
         Formation_Previous_Track    : Boolean := False;
         Formation_Next_Track        : Boolean := False;
         Formation_Snapshot          : Boolean := False;

         Ownship_Lat_Fract           : Long_Float := 0.0;
         Lead_Lat_Fract              : Long_Float := 0.0;

         Lead_To_Ownship_Distance    : Long_Float := 0.0;

         Fm_Lead_Ias                 : Float := 0.0;
         Fm_Float_1                  : Float := 0.0;
         Fm_Float_2                  : Float := 0.0;
         Fm_Float_3                  : Float := 0.0;
         Fm_Float_4                  : Float := 0.0;
         Fm_Float_5                  : Float := 0.0;

      end record;
   This_Ios_Interface : Ios_Interface_Instance;


end Jpats_Formation_Manager.Container;
