-------------------------------------------------------------------------------
--
--           FlightSafety International Simulation Systems Division
--                    Broken Arrow, OK  USA  918-259-4000
--
--                 JPATS T-6A Texan-II Flight Training Device
--
--
--  Engineer:  Keith H. Rehm
--
--  Revision:  (Number and date inserted by Clearcase)
--
--
-- DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
-- Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
-- technical or operational data or information from automatic dissemination
-- under the International Exchange Program or by other means.  This protection
-- covers information required solely for administrative or operational
-- purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--
-- WARNING:  This document contains technical data whose export is restricted
-- by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
-- Executive Order 12470.  Violation of these export control laws is subject
-- to severe criminal penalties.  Dissemination of this document is controlled
-- under DOD Directive 5230.25
--
-------------------------------------------------------------------------------

with Ada.Numerics.Discrete_Random;

package Formation_Lead_Kinematic is

   type Instance is private;

   procedure Initialize
     (An_Instance                 : in out Instance;
      Pitch_Angle_Init            : in     Float;
      Bank_Angle_Init             : in     Float;
      Heading_Init                : in     Float;
      Lat_Init                    : in     Long_Float;
      Long_Init                   : in     Long_Float;
      Geometric_Altitude_Init     : in     Float;
      V_Indicated_Airspeed_Init   : in     Float;
      Gear_Position_Init          : in     Float;
      Speedbrake_Position_Init    : in     Float;
      Flap_Position_Init          : in     Float;
      Elevator_Position_Init      : in     Float;
      Rudder_Position_Init        : in     Float;
      Right_Aileron_Position_Init : in     Float;
      Left_Aileron_Position_Init  : in     Float);

   procedure Update
     (An_Instance                    : in out Instance;
      Iconst                         : in     Float;
      Pitch_Attitude_Driver_Selected : in     Boolean := False;
      Airspeed_Driver_Selected       : in     Boolean := True;
      Pitch_Angle_Commanded          : in     Float := 0.0;
      Pitch_Rate                     : in     Float := 1.0;
      V_Indicated_Airspeed_Commanded : in     Float := 0.0;
      Velocity_Gain                  : in     Float := 0.0;
      Air_Density_At_Altitude        : in     Float := 0.0;
      Air_Density_At_Sea_Level       : in     Float := 0.0;
      Bank_Angle_Commanded           : in     Float := 0.0;
      Roll_Rate                      : in     Float := 1.0;
      Wing_Dip_Commanded             : in out Boolean;
      Porpoise_Commanded             : in out Boolean;
      Big_Wing_Rock_Commanded        : in out Boolean;
      Small_Wing_Rock_Commanded      : in out Boolean;
      Flaps_Up                       : in     Boolean := True;
      Flaps_Ldg                      : in     Boolean := False;
      Speedbrake_Deployed            : in     Boolean := False;
      Gear_Up                        : in     Boolean := False;
      Wingman_Lat                    : in     Long_Float := 0.0;
      Wingman_Long                   : in     Long_Float := 0.0);

   function Pitch_Angle
     (An_Instance : in Instance)
     return Float;
   function Bank_Angle
     (An_Instance : in Instance)
     return Float;
   function Heading
     (An_Instance : in Instance)
     return Float;
   function Lat
     (An_Instance : in Instance)
     return Long_Float;
   function Long
     (An_Instance : in Instance)
     return Long_Float;
   function Geometric_Altitude
     (An_Instance : in Instance)
     return Float;
   function Flap_Position
     (An_Instance : in Instance)
     return Float;
   function Speedbrake_Position
     (An_Instance : in Instance)
     return Float;
   function Gear_Position
     (An_Instance : in Instance)
     return Float;
   function V_True_Airspeed
     (An_Instance : in Instance)
     return Float;
   function V_Indicated_Airspeed
     (An_Instance : in Instance)
     return Float;
   function Elevator_Position
     (An_Instance : in Instance)
     return Float;
   function Rudder_Position
     (An_Instance : in Instance)
     return Float;
   function Right_Aileron_Position
     (An_Instance : in Instance)
     return Float;
   function Left_Aileron_Position
     (An_Instance : in Instance)
     return Float;

   procedure Set_Bank_Angle( An_Instance : in out Instance;
                             Bank_Angle : in Float);

   procedure Reset_RRD_Gen_From_State
     (An_Instance : in out Instance);

   procedure Reset_RRD_Gen;

private

   type State_Type is (Initializing,
                       Wing_Dip,
                       Porpoise,
                       Big_Wing_Rock,
                       Small_Wing_Rock,
                       Pitch_Attitude_Driver,
                       Airspeed_Driver);

   type Rock_Direction_Type is (Up, Down);

   package Random_Rock_Direction is new Ada.Numerics.Discrete_Random(Rock_Direction_Type);
--   use Random_Rock_Direction;
   RRD_Gen : Random_Rock_Direction.Generator;

   type Instance is
      record
         State                   : State_Type := Initializing;
         State_Lp                : State_Type := Initializing;

         Angle_Of_Attack         : Float := 5.0;
         Climb_Angle             : Float := 0.0;

         Pitch_Angle             : Float := 0.0;
         Bank_Angle              : Float := 0.0;
         Heading                 : Float := 0.0;

         Lat                     : Long_Float := 0.0;
         Long                    : Long_Float := 0.0;
         Geometric_Altitude      : Float := 0.0;

         V_Indicated_Airspeed    : Float := 0.0;
         V_True_Airspeed         : Float := 0.0;

         U_Body                  : Float := 0.0;
         V_Body                  : Float := 0.0;
         W_Body                  : Float := 0.0;

         U_Earth                 : Float := 0.0;
         V_Earth                 : Float := 0.0;
         W_Earth                 : Float := 0.0;
         W_Earth_Lp              : Float := 0.0;

         Side_Slip_Angle         : Float := 0.0;

         Gear_Position           : Float := 0.0;
         Speedbrake_Position     : Float := 0.0;
         Flap_Position           : Float := 0.0;
         Elevator_Position       : Float := 0.0;
         Rudder_Position         : Float := 0.0;
         Right_Aileron_Position  : Float := 0.0;
         Left_Aileron_Position   : Float := 0.0;
         --*****************************************************
         --*****************************************************
         Wing_Dip_Complete        : Boolean    := False;
         Porpoise_Complete        : Boolean    := False;
         Big_Wing_Rock_Complete   : Boolean    := False;
         Small_Wing_Rock_Complete : Boolean    := False;
         Last_Driver              : State_Type := Airspeed_Driver;
         Bank_Angle_Mark          : Float      := 0.0;
         Pitch_Angle_Mark         : Float      := 0.0;
         Left_Wing_Dip            : Boolean    := True;
         Wing_Lead_Distance       : Long_Float := 0.0;
         Wing_Dip_Angle           : Float      := 0.0;
         Target_Angle             : Float      := 0.0;
         Achieved_Target_Angle    : Boolean    := False;

         Achieved_Mark_Angle      : Boolean    := False;

         Achieved_First_Angle     : Boolean := False;
         Achieved_Second_Angle    : Boolean := False;
         Achieved_Third_Angle     : Boolean := False;
         Achieved_Fourth_Angle    : Boolean := False;
         Top_Angle                : Float := 0.0;
         Bottom_Angle             : Float := 0.0;
         Rock_Start               : Rock_Direction_Type := Up;

         Lower_Nose_Angle         : Float := 0.0;
         Upper_Nose_Angle         : Float := 0.0;

         RRD_Gen_State            : Random_Rock_Direction.State;

      end record;

end Formation_Lead_Kinematic;
