-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Coordinate_Types;

package Coordinate_Transformation is

    --| This method to be used for acceleration earth axis then, An_Input_Attribute = Force/Mass
    --| after this add 32.174 to z component of acceleration (i.e. The_Out_Attribute) in the
    --| controller and invoke the Assign_Out_Attribute method.
    --| To be used for formation flying to go from body axis to earth axis with the,
    --| An_Input_Attribute = body axis velocity and The_Out_Attribute is the earth axis velocity.
   function Body_to_Earth
     (Input_Attribute  :in     Coordinate_Types.Cartesian;
      Roll_Angle        :in     Angle_Types.Radians;
      Pitch_Angle       :in     Angle_Types.Radians;
      Yaw_Angle         :in     Angle_Types.Radians) return Coordinate_Types.Cartesian;

    --| This method to be used for translational and inertial velocity body axis then,
   --| An_Input_Attribute = velocity earth axis and The_Out_Attribute is the body axis
  --| velocity.
   function  Earth_to_Body
     (Input_Attribute  :in     Coordinate_Types.Cartesian;
      Roll_Angle        :in     Angle_Types.Radians;
      Pitch_Angle       :in     Angle_Types.Radians;
      Yaw_Angle         :in     Angle_Types.Radians) return Coordinate_Types.Cartesian;

end Coordinate_Transformation;

