-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Ada.Numerics.Elementary_Functions;        use Ada.Numerics.Elementary_Functions;

with Angle_Types;

package body Coordinate_Transformation is

    --| This method to be used for acceleration earth axis then, An_Input_Attribute = Force/Mass
    --| after this add 32.174 to z component of acceleration (i.e. The_Out_Attribute) in the
    --| controller and invoke the Assign_Out_Attribute method.
    --| To be used for formation flying to go from body axis to earth axis with the,
    --| An_Input_Attribute = body axis velocity and The_Out_Attribute is the earth axis velocity.
   function Body_to_Earth
     (Input_Attribute  :in     Coordinate_Types.Cartesian;
      Roll_Angle        :in     Angle_Types.Radians;
      Pitch_Angle       :in     Angle_Types.Radians;
      Yaw_Angle         :in     Angle_Types.Radians) return Coordinate_Types.Cartesian is
      Sine_Roll      : Float  := Sin(Roll_Angle) ;
      Cosine_Roll    : Float  := Cos(Roll_Angle) ;
      Sine_Pitch     : Float  := Sin(Pitch_Angle);
      Cosine_Pitch   : Float  := Cos(Pitch_Angle);
      Sine_Yaw       : Float  := Sin(Yaw_Angle)  ;
      Cosine_Yaw     : Float  := Cos(Yaw_Angle)  ;
      Out_Attribute : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
   begin
      Out_Attribute.x := Cosine_Pitch * Cosine_Yaw * Input_Attribute.x
        + (Sine_Roll * Sine_Pitch * Cosine_Yaw - Cosine_Roll * Sine_Yaw)
        * Input_Attribute.y
        + (Cosine_Roll * Sine_Pitch * Cosine_Yaw + Sine_Roll * Sine_Yaw)
        * Input_Attribute.z;

      Out_Attribute.y := Cosine_Pitch * Sine_Yaw * Input_Attribute.x
        + (Sine_Roll * Sine_Pitch * Sine_Yaw + Cosine_Roll * Cosine_Yaw)
        * Input_Attribute.y
        + (Cosine_Roll * Sine_Pitch * Sine_Yaw - Sine_Roll * Cosine_Yaw)
        * Input_Attribute.z;

      Out_Attribute.z := - Sine_Pitch * Input_Attribute.x
        + Sine_Roll   * Cosine_Pitch * Input_Attribute.y
        + Cosine_Roll * Cosine_Pitch * Input_Attribute.z;
        return Out_Attribute;
   end Body_to_Earth;

    --| This method to be used for translational and inertial velocity body axis then,
   --| An_Input_Attribute = velocity earth axis and The_Out_Attribute is the body axis
  --| velocity.
   function  Earth_to_Body
     (Input_Attribute  :in     Coordinate_Types.Cartesian;
      Roll_Angle        :in     Angle_Types.Radians;
      Pitch_Angle       :in     Angle_Types.Radians;
      Yaw_Angle         :in     Angle_Types.Radians) return Coordinate_Types.Cartesian is
      Sine_Roll      : Float  := Sin(Roll_Angle) ;
      Cosine_Roll    : Float  := Cos(Roll_Angle) ;
      Sine_Pitch     : Float  := Sin(Pitch_Angle);
      Cosine_Pitch   : Float  := Cos(Pitch_Angle);
      Sine_Yaw       : Float  := Sin(Yaw_Angle)  ;
      Cosine_Yaw     : Float  := Cos(Yaw_Angle)  ;
      Out_Attribute : Coordinate_Types.Cartesian := (0.0,0.0,0.0);
   begin
     Out_Attribute.x :=  Cosine_Pitch * Cosine_Yaw * Input_Attribute.x
       + Cosine_Pitch * Sine_Yaw * Input_Attribute.y
       - Sine_Pitch   * Input_Attribute.z;

      Out_Attribute.y := (  Sine_Roll   * Sine_Pitch * Cosine_Yaw
                                          - Cosine_Roll * Sine_Yaw)  * Input_Attribute.x
        + (Sine_Roll * Sine_Pitch * Sine_Yaw + Cosine_Roll * Cosine_Yaw) * Input_Attribute.y
        +  Sine_Roll * Cosine_Pitch * Input_Attribute.z;

      Out_Attribute.z := (  Cosine_Roll * Sine_Pitch * Cosine_Yaw
                                          + Sine_Roll   * Sine_Yaw)  * Input_Attribute.x
        + (Cosine_Roll * Sine_Pitch * Sine_Yaw - Sine_Roll * Cosine_Yaw) * Input_Attribute.y
        + Cosine_Roll  * Cosine_Pitch * Input_Attribute.z;
        return Out_Attribute;
   end Earth_to_Body;

end Coordinate_Transformation;
