-------------------------------------------------------------------------------
--|
--|            FlightSafety International Simulation Systems Division
--|                     Broken Arrow, OK  USA  918-259-4000
--|
--|                  JPATS T-6A Texan-II Flight Training Device
--|
--|
--|   Engineer:  Yogesh Tupe
--|
--|   Revision:  (Number and date inserted by Clearcase)
--|
--|
--|  DISTRIBUTION "D":  Distribution authorized to Department of Defense (DOD),
--|  Raytheon Aircraft Company (RAC), and DOD subcontractors only to protect
--|  technical or operational data or information from automatic dissemination
--|  under the International Exchange Program or by other means.  This protection
--|  covers information required solely for administrative or operational
--|  purposes, date of document as shown hereon 3 April 1998 ASC/YTK.
--|
--|  WARNING:  This document contains technical data whose export is restricted
--|  by the Arms Export Control Act (Title 22, U. S. C. 2751 et seq) or
--|  Executive Order 12470.  Violation of these export control laws is subject
--|  to severe criminal penalties.  Dissemination of this document is controlled
--|  under DOD Directive 5230.25
--|
-------------------------------------------------------------------------------
--|
with Angle_Types;
with Normalized_Types;
with Length_Types;

with Interpolation_Table.Singly_Indexed;

package Buffet is

   type Instance is private;

   procedure Set_Stall_Buffet (Calibrated_Airspeed :in     Length_Types.Knots;
                               Stall_Speed         :in     Length_Types.Knots;
                               Flap_Position       :in     Angle_Types.Degrees;
                               SABDS_Table           :in out Interpolation_Table.Singly_Indexed.Instance;
                               An_Instance           :in out Instance);

   procedure Assign_Stall_Buffet
     (Init_Stall_Buffet_Magnitude :in     Normalized_Types.Normalize;
      An_Instance                         :in out Instance);

   function Get_Stall_Buffet(An_Instance :in Instance) return Normalized_Types.Normalize;

private
   type Instance is
      record
         The_Stall_Buffet_Magnitude : Normalized_Types.Normalize;
      end record;

end Buffet;
